/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.util;

import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.Nullable;
import org.samo_lego.fabrictailor.FabricTailor;

public class SkinFetcher {
    /*
     * Enabled aggressive exception aggregation
     */
    public static Property setSkinFromFile(String skinFilePath, boolean useSlim) {
        block10: {
            File skinFile = new File(skinFilePath);
            try (FileInputStream input = new FileInputStream(skinFile);){
                if (input.read() != 137) break block10;
                try {
                    String reply = SkinFetcher.urlRequest(URI.create("https://api.mineskin.org/generate/upload?model=" + (useSlim ? "slim" : "steve")).toURL(), false, skinFile);
                    Property property = SkinFetcher.getSkinFromReply(reply);
                    return property;
                }
                catch (IOException e) {
                    FabricTailor.errorLog(e.getMessage());
                }
            }
            catch (IOException e) {
                FabricTailor.errorLog(e.getMessage());
            }
        }
        return null;
    }

    @Nullable
    public static Property fetchSkinByUrl(String skinUrl, boolean useSlim) {
        try {
            URL url = URI.create(String.format("https://api.mineskin.org/generate/url?url=%s&model=%s", URLEncoder.encode(skinUrl, StandardCharsets.UTF_8), useSlim ? "slim" : "steve")).toURL();
            String reply = SkinFetcher.urlRequest(url, false, null);
            return SkinFetcher.getSkinFromReply(reply);
        }
        catch (IOException e) {
            FabricTailor.errorLog(e.getMessage());
            return null;
        }
    }

    @Nullable
    public static Property fetchSkinByName(String playername) {
        try {
            String reply = SkinFetcher.urlRequest(URI.create("https://api.mojang.com/users/profiles/minecraft/" + playername).toURL(), true, null);
            if (reply == null || !reply.contains("id")) {
                reply = SkinFetcher.urlRequest(URI.create(String.format("http://skinsystem.ely.by/textures/signed/%s.png?proxy=true", playername)).toURL(), false, null);
            } else {
                String uuid = JsonParser.parseString((String)reply).getAsJsonObject().get("id").getAsString();
                reply = SkinFetcher.urlRequest(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false").toURL(), true, null);
            }
            return SkinFetcher.getSkinFromReply(reply);
        }
        catch (IOException e) {
            FabricTailor.errorLog(e.getMessage());
            return null;
        }
    }

    @Nullable
    protected static Property getSkinFromReply(String reply) {
        if (reply == null || reply.contains("error") || reply.isEmpty()) {
            return null;
        }
        String value = reply.split("\"value\":\"")[1].split("\"")[0];
        String signature = reply.split("\"signature\":\"")[1].split("\"")[0];
        return new Property("textures", value, signature);
    }

    private static String urlRequest(URL url, boolean useGetMethod, @Nullable File image) throws IOException {
        URLConnection connection = url.openConnection();
        String reply = null;
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setUseCaches(false);
            httpsConnection.setDoOutput(true);
            httpsConnection.setDoInput(true);
            httpsConnection.setRequestMethod(useGetMethod ? "GET" : "POST");
            if (image != null) {
                String boundary = UUID.randomUUID().toString();
                httpsConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                httpsConnection.setRequestProperty("User-Agent", "User-Agent");
                OutputStream outputStream = httpsConnection.getOutputStream();
                PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
                String LINE = "\r\n";
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"file\"").append("\r\n");
                writer.append("Content-Type: text/plain; charset=UTF-8").append("\r\n");
                writer.append("\r\n");
                writer.append(image.getName()).append("\r\n");
                writer.flush();
                writer.append("--").append(boundary).append("\r\n");
                writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(image.getName()).append("\"").append("\r\n");
                writer.append("Content-Type: image/png").append("\r\n");
                writer.append("Content-Transfer-Encoding: binary").append("\r\n");
                writer.append("\r\n");
                writer.flush();
                byte[] fileBytes = Files.readAllBytes(image.toPath());
                outputStream.write(fileBytes, 0, fileBytes.length);
                outputStream.flush();
                writer.append("\r\n");
                writer.flush();
                writer.append("--").append(boundary).append("--").append("\r\n");
                writer.close();
            }
            if (httpsConnection.getResponseCode() == 200) {
                reply = SkinFetcher.getContent(connection);
            }
            httpsConnection.disconnect();
        } else {
            reply = SkinFetcher.getContent(connection);
        }
        return reply;
    }

    /*
     * Exception decompiling
     */
    private static String getContent(URLConnection connection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

