/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.client.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_457;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.samo_lego.fabrictailor.client.ClientTailor;
import org.samo_lego.fabrictailor.client.screen.tabs.CapeTab;
import org.samo_lego.fabrictailor.client.screen.tabs.LocalSkinTab;
import org.samo_lego.fabrictailor.client.screen.tabs.PlayerSkinTab;
import org.samo_lego.fabrictailor.client.screen.tabs.SkinTabType;
import org.samo_lego.fabrictailor.client.screen.tabs.UrlSkinTab;
import org.samo_lego.fabrictailor.mixin.client.AAbstractClientPlayer;
import org.samo_lego.fabrictailor.network.payload.DefaultSkinPayload;
import org.samo_lego.fabrictailor.util.TextTranslations;

@Environment(value=EnvType.CLIENT)
public class SkinChangeScreen
extends class_437 {
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_WIDTH = 100;
    private static final List<SkinTabType> TABS = Arrays.asList(new PlayerSkinTab(), new UrlSkinTab(), new LocalSkinTab(), new CapeTab());
    private class_342 skinInput;
    private int startX;
    private int startY;
    protected SkinTabType selectedTab;
    protected class_4286 skinModelCheckbox;
    private class_4185 openExplorerButton;

    public SkinChangeScreen() {
        super((class_2561)TextTranslations.create("options.skinCustomisation.title", new Object[0]));
    }

    protected void method_25426() {
        super.method_25426();
        int verticalSpacing = 8;
        this.openExplorerButton = class_4185.method_46430((class_2561)TextTranslations.create("button.fabrictailor.open_explorer", new Object[0]), buttonWidget -> class_156.method_668().method_672(new File(""))).method_46436(class_7919.method_47407((class_2561)TextTranslations.create("hint.fabrictailor.dragAndDrop", new Object[0]))).method_46433(this.field_22789 / 2, this.field_22790 / 2 + 10).method_46436(class_7919.method_47407((class_2561)TextTranslations.create("hint.fabrictailor.dragAndDrop", new Object[0]))).method_46437(100, 20).method_46431();
        this.method_37063((class_364)this.openExplorerButton);
        this.skinModelCheckbox = class_4286.method_54787((class_2561)TextTranslations.create("button.fabrictailor.use_slim", new Object[0]), (class_327)this.field_22793).method_54789(this.field_22789 / 2, this.field_22790 / 2 - 12).method_54794(false).method_54788();
        this.method_37063((class_364)this.skinModelCheckbox);
        this.openExplorerButton.field_22764 = false;
        this.skinModelCheckbox.field_22764 = false;
        this.skinInput = new class_342(this.field_22793, this.field_22789 / 2, this.field_22790 / 2 - 29, 100, 14, (class_2561)class_2561.method_43471((String)"itemGroup.search").method_27692(class_124.field_1068));
        this.skinInput.method_1880(256);
        this.skinInput.method_1862(true);
        this.skinInput.method_1858(true);
        this.skinInput.method_1868(0xFFFFFF);
        this.method_25429((class_364)this.skinInput);
        this.method_37063((class_364)class_4185.method_46430((class_2561)TextTranslations.create("button.fabrictailor.apply", new Object[0]), onClick -> {
            this.applyNewSkin();
            this.method_25419();
        }).method_46433(this.field_22789 / 2, this.field_22790 / 2 + 30).method_46437(100, 20).method_46431());
        int buttonY = this.field_22790 - 20 - verticalSpacing;
        boolean allowDefaultSkinButton = ClientTailor.ALLOW_DEFAULT_SKIN || this.field_22787.method_1496();
        this.method_37063((class_364)class_4185.method_46430((class_2561)TextTranslations.create("button.fabrictailor.clear_skin", new Object[0]), onClick -> {
            this.clearSkin();
            this.method_25419();
        }).method_46433(this.field_22789 / 2 - 100 - (allowDefaultSkinButton ? 50 : 0) - 2, buttonY).method_46437(100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, onClick -> this.method_25419()).method_46433(this.field_22789 / 2 + (allowDefaultSkinButton ? 50 : 0) + 2, buttonY).method_46437(100, 20).method_46431());
        if (allowDefaultSkinButton) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)TextTranslations.create("button.fabrictailor.set_default_skin", new Object[0]), onClick -> {
                GameProfile profile = ((AAbstractClientPlayer)this.field_22787.field_1724).ft_getPlayerInfo().method_2966();
                Optional optionalProperty = profile.getProperties().get((Object)"textures").stream().findFirst();
                if (optionalProperty.isPresent()) {
                    DefaultSkinPayload payload = new DefaultSkinPayload((Property)optionalProperty.get());
                    ClientPlayNetworking.send((class_8710)payload);
                }
                this.method_25419();
            }).method_46433(this.field_22789 / 2 - 50 - 1, buttonY).method_46437(100, 20).method_46431());
        }
    }

    private void clearSkin() {
        if (ClientTailor.TAILORED_SERVER) {
            this.field_22787.field_1724.field_3944.method_45731("skin clear");
        } else {
            ((AAbstractClientPlayer)this.field_22787.field_1724).ft_getPlayerInfo().method_2966().getProperties().removeAll((Object)"textures");
        }
    }

    private void applyNewSkin() {
        new CompletableFuture<Object>().completeAsync(() -> {
            Optional<class_8710> packetInfo = this.selectedTab.getSkinChangePacket(this.field_22787.field_1724, this.skinInput.method_1882(), this.skinModelCheckbox.method_20372());
            packetInfo.ifPresent(packet -> {
                if (ClientTailor.TAILORED_SERVER) {
                    ClientPlayNetworking.send((class_8710)packet);
                } else {
                    PropertyMap propertyMap = ((AAbstractClientPlayer)this.field_22787.field_1724).ft_getPlayerInfo().method_2966().getProperties();
                }
            });
            return null;
        });
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics, 0, 0, 0.5f);
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        this.startX = (this.field_22789 - 252) / 2;
        this.startY = (this.field_22790 - 140) / 2;
        RenderSystem.enableBlend();
        guiGraphics.method_25302(class_457.field_2717, this.startX, this.startY, 0, 0, 252, 140);
        this.skinInput.method_25394(guiGraphics, this.startX, this.startY, delta);
        this.drawTabs(guiGraphics, this.startX, this.startY);
        this.drawIcons(guiGraphics, this.startX, this.startY);
        this.drawWidgetTooltips(guiGraphics, this.startX, this.startY, mouseX, mouseY);
        if (this.selectedTab.showModelBackwards()) {
            float mousex = -((float)this.field_22789 / 2.0f - 75.0f - (float)mouseX);
            float mousey = (float)this.field_22790 / 2.0f - (float)mouseY;
            class_746 player = this.field_22787.field_1724;
            float f = (float)Math.atan(mousex / 40.0f);
            float g = (float)Math.atan(mousey / 40.0f);
            int x = this.startX + 24;
            int y = this.startY - 76;
            this.renderEntityInInventoryFollowsMouseBackwards(guiGraphics, x, y, x + 75, y + 208, 48, 1.0f, mouseX + 2, mouseY - 16, (class_1309)this.field_22787.field_1724);
        } else {
            int x = this.startX + 24;
            int y = this.startY - 76;
            class_490.method_2486((class_332)guiGraphics, (int)x, (int)y, (int)(x + 75), (int)(y + 208), (int)48, (float)1.0f, (float)(mouseX + 2), (float)(mouseY - 16), (class_1309)this.field_22787.field_1724);
        }
    }

    public void renderEntityInInventoryFollowsMouseBackwards(class_332 guiGraphics, int i, int j, int k, int l, int m, float f, float g, float h, class_1309 livingEntity) {
        float mousex = -((float)this.field_22789 / 2.0f - 75.0f - g);
        float mousey = (float)this.field_22790 / 2.0f - h;
        float n = (float)(i + k) / 2.0f;
        float o = (float)(j + l) / 2.0f;
        float p = (float)Math.atan(mousex / 40.0f);
        float q = (float)Math.atan(mousey / 40.0f);
        guiGraphics.method_44379(i, j, k, l);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(q * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float r = livingEntity.field_6283;
        float s = livingEntity.method_36454();
        float t = livingEntity.method_36455();
        float u = livingEntity.field_6259;
        float v = livingEntity.field_6241;
        livingEntity.field_6283 = p * 40.0f;
        livingEntity.method_36456(p * 40.0f);
        livingEntity.method_36457(-q * 40.0f);
        livingEntity.field_6241 = livingEntity.method_36454();
        livingEntity.field_6259 = livingEntity.method_36454();
        float w = livingEntity.method_55693();
        Vector3f vector3f = new Vector3f(0.0f, livingEntity.method_17682() / 2.0f + f * w, 0.0f);
        float x = (float)m / w;
        class_490.method_48472((class_332)guiGraphics, (float)n, (float)o, (float)x, (Vector3f)vector3f, (Quaternionf)quaternionf, (Quaternionf)quaternionf2, (class_1309)livingEntity);
        livingEntity.field_6283 = r;
        livingEntity.method_36456(s);
        livingEntity.method_36457(t);
        livingEntity.field_6259 = u;
        livingEntity.field_6241 = v;
        guiGraphics.method_44380();
    }

    private void drawTabs(class_332 guiGraphics, int startX, int startY) {
        if (this.selectedTab == null) {
            this.selectedTab = TABS.get(0);
        }
        for (int i = 0; i < TABS.size(); ++i) {
            boolean selected;
            SkinTabType tab = TABS.get(i);
            boolean bl = selected = this.selectedTab == tab;
            if (selected) {
                this.skinModelCheckbox.field_22764 = tab.hasSkinModels();
                this.openExplorerButton.field_22764 = tab.showExplorerButton();
            }
            tab.getTabType().method_2301(guiGraphics, startX, startY, selected, tab.getTabType().method_2304() - i - 1);
        }
        guiGraphics.method_27535(this.field_22793, this.selectedTab.getTitle(), startX + 10, startY + 5, 0xFFFFFF);
        guiGraphics.method_27535(this.field_22793, this.selectedTab.getDescription(), this.field_22789 / 2, this.field_22790 / 2 - 40, 0xFFFFFF);
    }

    private void drawIcons(class_332 guiGraphics, int startX, int startY) {
        for (int i = 0; i < TABS.size(); ++i) {
            SkinTabType tab = TABS.get(i);
            tab.getTabType().method_2306(guiGraphics, startX, startY, tab.getTabType().method_2304() - i - 1, tab.getIcon());
        }
    }

    private void drawWidgetTooltips(class_332 guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        for (int i = 0; i < TABS.size(); ++i) {
            SkinTabType tab = TABS.get(i);
            if (!tab.getTabType().method_2303(startX, startY, tab.getTabType().method_2304() - i - 1, (double)mouseX, (double)mouseY)) continue;
            guiGraphics.method_51438(this.field_22793, tab.getTitle(), mouseX, mouseY);
            break;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            for (int i = 0; i < TABS.size(); ++i) {
                SkinTabType tab = TABS.get(i);
                boolean mouseOver = tab.getTabType().method_2303(this.startX, this.startY, tab.getTabType().method_2304() - i - 1, mouseX, mouseY);
                if (!mouseOver) continue;
                this.selectedTab = tab;
                break;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_29638(List<Path> paths) {
        if (!(this.selectedTab instanceof PlayerSkinTab)) {
            this.skinInput.method_1852(paths.iterator().next().toString());
        }
    }
}

