/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.ITreeBlock;
import ht.treechop.api.TreeChopAPI;
import ht.treechop.api.TreeData;
import ht.treechop.api.TreeDetectorBuilder;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.util.BlockNeighbors;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ProblematicLeavesTreeHandler
implements ITreeBlock {
    private static ITreeBlock detectionHandler;
    private static final Lazy<Set<class_2248>> logs;
    private static final Lazy<Set<class_2248>> leaves;

    public static void register(TreeChopAPI api) {
        detectionHandler = new TreeDetectorBuilder().logs(ProblematicLeavesTreeHandler::isLog).leaves(ProblematicLeavesTreeHandler::isLeaves).maxLeavesDistance(7).leavesScanner((level, pos) -> BlockNeighbors.ADJACENTS_AND_DIAGONALS.asStream((class_2338)pos)).leavesStrategy(TreeDetectorBuilder.LeavesStrategy.SHORTEST_PATH).build();
        ProblematicLeavesTreeHandler handler = new ProblematicLeavesTreeHandler();
        logs.get().forEach(block -> {
            api.overrideChoppableBlock((class_2248)block, true);
            api.registerBlockBehavior((class_2248)block, handler);
        });
        leaves.get().forEach(block -> api.overrideLeavesBlock((class_2248)block, true));
    }

    @Override
    public TreeData getTree(class_1937 level, class_2338 origin) {
        return detectionHandler.getTree(level, origin);
    }

    public static boolean isLog(class_1937 level, class_2338 pos, class_2680 state) {
        return logs.get().contains(state.method_26204());
    }

    public static boolean isLeaves(class_1937 level, class_2338 pos, class_2680 state) {
        return leaves.get().contains(state.method_26204());
    }

    static {
        logs = new Lazy<Set>(ConfigHandler.RELOAD, () -> ConfigHandler.getIdentifiedBlocks((List)MyConfigHandler.instance.logIds.get()).collect(Collectors.toSet()));
        leaves = new Lazy<Set>(ConfigHandler.RELOAD, () -> ConfigHandler.getIdentifiedBlocks((List)MyConfigHandler.instance.leavesIds.get()).collect(Collectors.toSet()));
    }

    public static class MyConfigHandler {
        private static MyConfigHandler instance;
        protected final ModConfigSpec.ConfigValue<List<? extends String>> logIds;
        protected final ModConfigSpec.ConfigValue<List<? extends String>> leavesIds;

        public MyConfigHandler(ModConfigSpec.Builder builder) {
            builder.push("problematicLeavesTrees");
            this.logIds = builder.defineListAllowEmpty("logs", List.of("tropicraft:.*_log(_.*)?", "mysticbiomes:.*_log", "betternether:.*_bark", "betternether:.*_log", "alexscaves:.*_log", "alexscaves:pewen_wood"), always -> true);
            this.leavesIds = builder.defineListAllowEmpty("leaves", List.of("tropicraft:.*_leaves(_.*)?", "betternether:.*_leaves", "regions_unexplored:brimwood_leaves", "alexscaves:.*_branch", "alexscaves:pewen_pines"), always -> true);
            builder.pop();
        }

        public static void init(ModConfigSpec.Builder builder) {
            instance = new MyConfigHandler(builder);
        }
    }
}

