/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_853;

@Environment(value=EnvType.CLIENT)
public class ChunkRenderInfo {
    private final Long2IntOpenHashMap brightnessCache = new Long2IntOpenHashMap();
    private final Long2FloatOpenHashMap aoLevelCache;
    private Function<class_1921, class_287> bufferFunc;
    class_1920 blockView;

    ChunkRenderInfo() {
        this.brightnessCache.defaultReturnValue(Integer.MAX_VALUE);
        this.aoLevelCache = new Long2FloatOpenHashMap();
        this.aoLevelCache.defaultReturnValue(Float.MAX_VALUE);
    }

    void prepare(class_853 blockView, Function<class_1921, class_287> bufferFunc) {
        this.blockView = blockView;
        this.bufferFunc = bufferFunc;
        this.brightnessCache.clear();
        this.aoLevelCache.clear();
    }

    void release() {
        this.blockView = null;
        this.bufferFunc = null;
    }

    class_287 getBuffer(class_1921 layer) {
        return this.bufferFunc.apply(layer);
    }

    int cachedBrightness(class_2338 pos, class_2680 state) {
        long key = pos.method_10063();
        int result = this.brightnessCache.get(key);
        if (result == Integer.MAX_VALUE) {
            result = AoCalculator.getLightmapCoordinates(this.blockView, state, pos);
            this.brightnessCache.put(key, result);
        }
        return result;
    }

    float cachedAoLevel(class_2338 pos, class_2680 state) {
        long key = pos.method_10063();
        float result = this.aoLevelCache.get(key);
        if (result == Float.MAX_VALUE) {
            result = AoLuminanceFix.INSTANCE.apply((class_1922)this.blockView, pos, state);
            this.aoLevelCache.put(key, result);
        }
        return result;
    }
}

