/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.screenhandler.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.impl.screenhandler.Networking;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public final class ClientNetworking
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-screen-handler-api-v1/client");

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(Networking.OpenScreenPayload.ID, (payload, context) -> this.openScreen((Networking.OpenScreenPayload)payload));
    }

    private <D> void openScreen(Networking.OpenScreenPayload<D> payload) {
        class_2960 typeId = payload.identifier();
        int syncId = payload.syncId();
        class_2561 title = payload.title();
        class_3917 type = (class_3917)class_7923.field_41187.method_10223(typeId);
        if (type == null || payload.data() == null) {
            LOGGER.warn("Unknown screen handler ID: {}", (Object)typeId);
            return;
        }
        if (!(type instanceof ExtendedScreenHandlerType)) {
            LOGGER.warn("Received extended opening packet for non-extended screen handler {}", (Object)typeId);
            return;
        }
        class_3929.class_3930 screenFactory = class_3929.method_17540((class_3917)type);
        if (screenFactory != null) {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            class_437 screen = screenFactory.create(((ExtendedScreenHandlerType)type).create(syncId, player.method_31548(), payload.data()), player.method_31548(), title);
            player.field_7512 = ((class_3936)screen).method_17577();
            client.method_1507(screen);
        } else {
            LOGGER.warn("Screen not registered for screen handler {}!", (Object)typeId);
        }
    }
}

