/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.entity.event;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Optional;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
abstract class LivingEntityMixin {
    LivingEntityMixin() {
    }

    @Shadow
    public abstract boolean method_29504();

    @Shadow
    public abstract Optional<class_2338> method_18398();

    @WrapOperation(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onKilledOther(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/LivingEntity;)Z")})
    private boolean onEntityKilledOther(class_1297 entity, class_3218 serverWorld, @Nullable class_1309 attacker, Operation<Boolean> original) {
        boolean result = (Boolean)original.call(new Object[]{entity, serverWorld, attacker});
        ((ServerEntityCombatEvents.AfterKilledOtherEntity)ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.invoker()).afterKilledOtherEntity(serverWorld, entity, attacker);
        return result;
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="net/minecraft/world/World.sendEntityStatus(Lnet/minecraft/entity/Entity;B)V")})
    private void notifyDeath(class_1282 source, CallbackInfo ci) {
        ((ServerLivingEntityEvents.AfterDeath)ServerLivingEntityEvents.AFTER_DEATH.invoker()).afterDeath((class_1309)this, source);
    }

    @Redirect(method={"damage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isDead()Z", ordinal=1))
    boolean beforeEntityKilled(class_1309 livingEntity, class_1282 source, float amount) {
        return this.method_29504() && ((ServerLivingEntityEvents.AllowDeath)ServerLivingEntityEvents.ALLOW_DEATH.invoker()).allowDeath(livingEntity, source, amount);
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="net/minecraft/entity/LivingEntity.isSleeping()Z")}, cancellable=true)
    private void beforeDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (!((ServerLivingEntityEvents.AllowDamage)ServerLivingEntityEvents.ALLOW_DAMAGE.invoker()).allowDamage((class_1309)this, source, amount)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void afterDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir, float dealt, boolean blocked) {
        if (!this.method_29504()) {
            ((ServerLivingEntityEvents.AfterDamage)ServerLivingEntityEvents.AFTER_DAMAGE.invoker()).afterDamage((class_1309)this, source, dealt, amount, blocked);
        }
    }

    @Inject(method={"sleep"}, at={@At(value="RETURN")})
    private void onSleep(class_2338 pos, CallbackInfo info) {
        ((EntitySleepEvents.StartSleeping)EntitySleepEvents.START_SLEEPING.invoker()).onStartSleeping((class_1309)this, pos);
    }

    @Inject(method={"wakeUp"}, at={@At(value="HEAD")})
    private void onWakeUp(CallbackInfo info) {
        class_2338 sleepingPos = this.method_18398().orElse(null);
        if (sleepingPos != null) {
            ((EntitySleepEvents.StopSleeping)EntitySleepEvents.STOP_SLEEPING.invoker()).onStopSleeping((class_1309)this, sleepingPos);
        }
    }

    @Inject(method={"method_18405"}, at={@At(value="RETURN")}, cancellable=true)
    @Dynamic(value="method_18405: Synthetic lambda body for Optional.map in isSleepingInBed")
    private void onIsSleepingInBed(class_2338 sleepingPos, CallbackInfoReturnable<Boolean> info) {
        class_2680 bedState = ((class_1309)this).method_37908().method_8320(sleepingPos);
        class_1269 result = ((EntitySleepEvents.AllowBed)EntitySleepEvents.ALLOW_BED.invoker()).allowBed((class_1309)this, sleepingPos, bedState, info.getReturnValueZ());
        if (result != class_1269.field_5811) {
            info.setReturnValue((Object)result.method_23665());
        }
    }

    @WrapOperation(method={"getSleepingDirection"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BedBlock;getDirection(Lnet/minecraft/world/BlockView;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/Direction;")})
    private class_2350 onGetSleepingDirection(class_1922 world, class_2338 sleepingPos, Operation<class_2350> operation) {
        class_2350 sleepingDirection = (class_2350)operation.call(new Object[]{world, sleepingPos});
        return ((EntitySleepEvents.ModifySleepingDirection)EntitySleepEvents.MODIFY_SLEEPING_DIRECTION.invoker()).modifySleepDirection((class_1309)this, sleepingPos, sleepingDirection);
    }

    @ModifyVariable(method={"method_18404", "sleep"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/BlockState;"))
    @Dynamic(value="method_18404: Synthetic lambda body for Optional.ifPresent in wakeUp")
    private class_2680 modifyBedForOccupiedState(class_2680 state, class_2338 sleepingPos) {
        class_1269 result = ((EntitySleepEvents.AllowBed)EntitySleepEvents.ALLOW_BED.invoker()).allowBed((class_1309)this, sleepingPos, state, state.method_26204() instanceof class_2244);
        return result.method_23665() ? class_2246.field_10069.method_9564() : state;
    }

    @Redirect(method={"method_18404", "sleep"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z"))
    @Dynamic(value="method_18404: Synthetic lambda body for Optional.ifPresent in wakeUp")
    private boolean setOccupiedState(class_1937 world, class_2338 pos, class_2680 state, int flags) {
        class_2680 originalState = world.method_8320(pos);
        boolean occupied = (Boolean)state.method_11654((class_2769)class_2244.field_9968);
        if (((EntitySleepEvents.SetBedOccupationState)EntitySleepEvents.SET_BED_OCCUPATION_STATE.invoker()).setBedOccupationState((class_1309)this, pos, originalState, occupied)) {
            return true;
        }
        if (originalState.method_28498((class_2769)class_2244.field_9968)) {
            return world.method_8652(pos, (class_2680)originalState.method_11657((class_2769)class_2244.field_9968, (Comparable)Boolean.valueOf(occupied)), flags);
        }
        return false;
    }

    @Redirect(method={"method_18404"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/BedBlock;findWakeUpPosition(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/CollisionView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;F)Ljava/util/Optional;"))
    @Dynamic(value="method_18404: Synthetic lambda body for Optional.ifPresent in wakeUp")
    private Optional<class_243> modifyWakeUpPosition(class_1299<?> type, class_1941 world, class_2338 pos, class_2350 direction, float yaw) {
        Optional original = Optional.empty();
        class_2680 bedState = world.method_8320(pos);
        if (bedState.method_26204() instanceof class_2244) {
            original = class_2244.method_9484(type, (class_1941)world, (class_2338)pos, (class_2350)direction, (float)yaw);
        }
        class_243 newPos = ((EntitySleepEvents.ModifyWakeUpPosition)EntitySleepEvents.MODIFY_WAKE_UP_POSITION.invoker()).modifyWakeUpPosition((class_1309)this, pos, bedState, original.orElse(null));
        return Optional.ofNullable(newPos);
    }
}

