/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class ComponentsIngredient
implements CustomIngredient {
    public static final CustomIngredientSerializer<ComponentsIngredient> SERIALIZER = new Serializer();
    private final class_1856 base;
    private final class_9326 components;

    public ComponentsIngredient(class_1856 base, class_9326 components) {
        if (components.method_57848()) {
            throw new IllegalArgumentException("ComponentIngredient must have at least one defined component");
        }
        this.base = base;
        this.components = components;
    }

    @Override
    public boolean test(class_1799 stack) {
        if (!this.base.method_8093(stack)) {
            return false;
        }
        for (Map.Entry entry : this.components.method_57846()) {
            class_9331 type = (class_9331)entry.getKey();
            Optional value = (Optional)entry.getValue();
            if (value.isPresent()) {
                if (!stack.method_57826(type)) {
                    return false;
                }
                if (Objects.equals(value.get(), stack.method_57824(type))) continue;
                return false;
            }
            if (!stack.method_57826(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(List.of(this.base.method_8105()));
        stacks.replaceAll(stack -> {
            class_1799 copy = stack.method_7972();
            copy.method_59692(this.components);
            return copy;
        });
        stacks.removeIf(stack -> !this.base.method_8093(stack));
        return stacks;
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private class_1856 getBase() {
        return this.base;
    }

    @Nullable
    private class_9326 getComponents() {
        return this.components;
    }

    private static class Serializer
    implements CustomIngredientSerializer<ComponentsIngredient> {
        private static final class_2960 ID = class_2960.method_60655((String)"fabric", (String)"components");
        private static final MapCodec<ComponentsIngredient> ALLOW_EMPTY_CODEC = Serializer.createCodec((Codec<class_1856>)class_1856.field_46095);
        private static final MapCodec<ComponentsIngredient> DISALLOW_EMPTY_CODEC = Serializer.createCodec((Codec<class_1856>)class_1856.field_46096);
        private static final class_9139<class_9129, ComponentsIngredient> PACKET_CODEC = class_9139.method_56435((class_9139)class_1856.field_48355, ComponentsIngredient::getBase, (class_9139)class_9326.field_49590, ComponentsIngredient::getComponents, ComponentsIngredient::new);

        private Serializer() {
        }

        private static MapCodec<ComponentsIngredient> createCodec(Codec<class_1856> ingredientCodec) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ingredientCodec.fieldOf("base").forGetter(ComponentsIngredient::getBase), (App)class_9326.field_49589.fieldOf("components").forGetter(ComponentsIngredient::getComponents)).apply((Applicative)instance, ComponentsIngredient::new));
        }

        @Override
        public class_2960 getIdentifier() {
            return ID;
        }

        @Override
        public MapCodec<ComponentsIngredient> getCodec(boolean allowEmpty) {
            return allowEmpty ? ALLOW_EMPTY_CODEC : DISALLOW_EMPTY_CODEC;
        }

        @Override
        public class_9139<class_9129, ComponentsIngredient> getPacketCodec() {
            return PACKET_CODEC;
        }
    }
}

