/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.datagen.v1.provider;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLootTableProvider;
import net.fabricmc.fabric.impl.datagen.loot.FabricLootTableProviderImpl;
import net.minecraft.class_173;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7701;
import net.minecraft.class_7788;
import net.minecraft.class_7923;

public abstract class FabricBlockLootTableProvider
extends class_7788
implements FabricLootTableProvider {
    private final FabricDataOutput output;
    private final Set<class_2960> excludedFromStrictValidation = new HashSet<class_2960>();
    private final CompletableFuture<class_7225.class_7874> registryLookupFuture;

    protected FabricBlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(Collections.emptySet(), class_7701.field_40180.method_45383(), registryLookup.join());
        this.output = dataOutput;
        this.registryLookupFuture = registryLookup;
    }

    public abstract void method_10379();

    public void excludeFromStrictValidation(class_2248 block) {
        this.excludedFromStrictValidation.add(class_7923.field_41175.method_10221((Object)block));
    }

    public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> biConsumer) {
        this.method_10379();
        for (Map.Entry entry : this.field_40610.entrySet()) {
            class_5321 registryKey = (class_5321)entry.getKey();
            if (registryKey == class_39.field_844) continue;
            biConsumer.accept((class_5321<class_52>)registryKey, (class_52.class_53)entry.getValue());
        }
        if (this.output.isStrictValidationEnabled()) {
            HashSet missing = Sets.newHashSet();
            for (class_2960 blockId : class_7923.field_41175.method_10235()) {
                class_5321 blockLootTableId;
                if (!blockId.method_12836().equals(this.output.getModId()) || !(blockLootTableId = ((class_2248)class_7923.field_41175.method_10223(blockId)).method_26162()).method_29177().method_12836().equals(this.output.getModId()) || this.field_40610.containsKey(blockLootTableId)) continue;
                missing.add(blockId);
            }
            missing.removeAll(this.excludedFromStrictValidation);
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing loot table(s) for %s".formatted(missing));
            }
        }
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return FabricLootTableProviderImpl.run(writer, this, class_173.field_1172, this.output, this.registryLookupFuture);
    }

    public String method_10321() {
        return "Block Loot Tables";
    }
}

