/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.INameable;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageDoorbellNotification;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DoorbellBlockEntity
extends ElectricityModuleBlockEntity
implements INameable {
    public static final int MAX_NAME_LENGTH = 32;
    protected UUID owner;
    protected String customName = "";
    protected long lastPressedTime;
    protected boolean powered;

    public DoorbellBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.DOORBELL.get(), pos, state);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.method_5431();
    }

    @Override
    public boolean isNodePowered() {
        return this.powered;
    }

    @Override
    public void setNodePowered(boolean powered) {
        this.powered = powered;
        this.method_5431();
        if (!this.field_11863.method_8608()) {
            BlockEntityHelper.sendCustomUpdate(this, (entity, access) -> {
                class_2487 compound = new class_2487();
                compound.method_10556("Powered", powered);
                return compound;
            });
        }
    }

    @Override
    public void setName(@Nullable class_3222 player, String name) {
        if (this.owner == null || player == null) {
            return;
        }
        if (!this.owner.equals(player.method_5667())) {
            return;
        }
        if (!name.isBlank()) {
            this.customName = StringUtils.truncate((String)name, (int)32);
            this.method_5431();
        }
    }

    public void sendNotificationToOwner(@Nullable class_1657 presser) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 level = (class_3218)class_19372;
            if (this.owner != null) {
                MinecraftServer server = level.method_8503();
                class_3222 player = server.method_3760().method_14602(this.owner);
                if (player == null || level.method_8510() - this.lastPressedTime < 600L) {
                    return;
                }
                if (presser != null && presser.equals((Object)player)) {
                    return;
                }
                Network.getPlay().sendToPlayer(() -> player, (Object)new MessageDoorbellNotification(this.customName));
                this.lastPressedTime = level.method_8510();
            }
        }
    }

    @Override
    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_10573("Owner", 11)) {
            this.owner = tag.method_25926("Owner");
        }
        if (tag.method_10573("CustomName", 8)) {
            this.customName = tag.method_10558("CustomName");
        }
        if (tag.method_10573("Powered", 1)) {
            this.powered = tag.method_10577("Powered");
        }
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (this.owner != null) {
            tag.method_25927("Owner", this.owner);
        }
        tag.method_10556("Powered", this.powered);
        tag.method_10582("CustomName", this.customName);
    }
}

