/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.trender.gui.client.LibGui;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.client.NarrationMessages;
import dev.tr7zw.trender.gui.impl.client.style.WidgetTextures;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.InputResult;
import dev.tr7zw.trender.gui.widget.data.Texture;
import dev.tr7zw.trender.gui.widget.icon.Icon;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class WToggleButton
extends WWidget {
    private static final int ICON_SIZE = 16;
    protected Texture onImage;
    protected Texture offImage;
    protected Texture focusImage;
    @Nullable
    protected class_2561 label = null;
    @Nullable
    private Icon icon;
    protected boolean isOn = false;
    @Nullable
    protected Consumer<Boolean> onToggle = null;

    public WToggleButton() {
    }

    public WToggleButton(class_2561 label) {
        this.label = label;
    }

    public WToggleButton(class_2960 onImage, class_2960 offImage) {
        this(new Texture(onImage), new Texture(offImage));
    }

    public WToggleButton(class_2960 onImage, class_2960 offImage, class_2561 label) {
        this(new Texture(onImage), new Texture(offImage), label);
    }

    public WToggleButton(Texture onImage, Texture offImage) {
        this.onImage = onImage;
        this.offImage = offImage;
    }

    public WToggleButton(Texture onImage, Texture offImage, class_2561 label) {
        this.onImage = onImage;
        this.offImage = offImage;
        this.label = label;
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        ScreenDrawing.texturedRect(context, x, y, 18, 18, this.isOn ? this.getOnImage() : this.getOffImage(), -1, 18, 18);
        if (this.isFocused()) {
            ScreenDrawing.texturedRect(context, x, y, 18, 18, this.getFocusImage(), -1, 18, 18);
        }
        int xPos = x + 22;
        if (this.icon != null) {
            this.icon.paint(context, x + 22, y + 1, 16);
            xPos += 18;
        }
        if (this.label != null) {
            context.drawString(class_310.method_1551().field_1772, this.label.method_30937(), xPos, y + 6, LibGui.getGuiStyle().getTitleColor(), false);
        }
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public boolean canFocus() {
        return true;
    }

    @Override
    public InputResult onClick(int x, int y, int button) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        this.isOn = !this.isOn;
        this.onToggle(this.isOn);
        return InputResult.PROCESSED;
    }

    @Override
    public InputResult onKeyPressed(int ch, int key, int modifiers) {
        if (WToggleButton.isActivationKey(ch)) {
            this.onClick(0, 0, 0);
            return InputResult.PROCESSED;
        }
        return InputResult.IGNORED;
    }

    protected void onToggle(boolean on) {
        if (this.onToggle != null) {
            this.onToggle.accept(on);
        }
    }

    public boolean getToggle() {
        return this.isOn;
    }

    public void setToggle(boolean on) {
        this.isOn = on;
    }

    @Nullable
    public Consumer<Boolean> getOnToggle() {
        return this.onToggle;
    }

    public WToggleButton setOnToggle(@Nullable Consumer<Boolean> onToggle) {
        this.onToggle = onToggle;
        return this;
    }

    @Nullable
    public class_2561 getLabel() {
        return this.label;
    }

    public WToggleButton setLabel(@Nullable class_2561 label) {
        this.label = label;
        return this;
    }

    public Texture getOnImage() {
        return this.onImage != null ? this.onImage : WidgetTextures.getToggleButtonTextures().get().on();
    }

    public WToggleButton setOnImage(Texture onImage) {
        this.onImage = onImage;
        return this;
    }

    public Texture getOffImage() {
        return this.offImage != null ? this.offImage : WidgetTextures.getToggleButtonTextures().get().off();
    }

    public WToggleButton setOffImage(Texture offImage) {
        this.offImage = offImage;
        return this;
    }

    public Texture getFocusImage() {
        return this.focusImage != null ? this.focusImage : WidgetTextures.getToggleButtonTextures().get().focus();
    }

    public WToggleButton setFocusImage(Texture focusImage) {
        this.focusImage = focusImage;
        return this;
    }

    @Override
    public void addNarrations(class_6382 builder) {
        class_2561 onOff = this.isOn ? NarrationMessages.TOGGLE_BUTTON_ON : NarrationMessages.TOGGLE_BUTTON_OFF;
        class_5250 title = this.label != null ? ComponentProvider.translatable((String)"widget.libgui.toggle_button.narration.named", (Object[])new Object[]{this.label, onOff}) : ComponentProvider.translatable((String)"widget.libgui.toggle_button.narration.unnamed", (Object[])new Object[]{onOff});
        builder.method_37034(class_6381.field_33788, (class_2561)title);
        if (this.isFocused()) {
            builder.method_37034(class_6381.field_33791, NarrationMessages.Vanilla.BUTTON_USAGE_FOCUSED);
        } else if (this.isHovered()) {
            builder.method_37034(class_6381.field_33791, NarrationMessages.Vanilla.BUTTON_USAGE_HOVERED);
        }
    }

    @Nullable
    @Generated
    public Icon getIcon() {
        return this.icon;
    }

    @Generated
    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
    }
}

