/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.client.LibGui;
import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.client.ScreenDrawing;
import dev.tr7zw.trender.gui.impl.client.TextAlignment;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.HorizontalAlignment;
import dev.tr7zw.trender.gui.widget.data.InputResult;
import dev.tr7zw.trender.gui.widget.data.VerticalAlignment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class WLabel
extends WWidget {
    protected class_2561 text;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    protected Integer color = null;
    protected Boolean drawShadows;

    public WLabel(class_2561 text, int color) {
        this.text = text;
        this.color = color;
    }

    public WLabel(class_2561 text) {
        this.text = text;
    }

    @Override
    public void paint(RenderContext context, int x, int y, int mouseX, int mouseY) {
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.getHeight(), 1);
        if (this.getDrawShadows()) {
            ScreenDrawing.drawStringWithShadow(context, this.text.method_30937(), this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.getColor());
        } else {
            ScreenDrawing.drawString(context, this.text.method_30937(), this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.getColor());
        }
        class_2583 hoveredTextStyle = this.getTextStyleAt(mouseX, mouseY);
        ScreenDrawing.drawTextHover(context, hoveredTextStyle, x + mouseX, y + mouseY);
    }

    @Override
    public InputResult onClick(int x, int y, int button) {
        class_437 screen;
        class_2583 hoveredTextStyle = this.getTextStyleAt(x, y);
        if (hoveredTextStyle != null && (screen = class_310.method_1551().field_1755) != null) {
            return InputResult.of(screen.method_25430(hoveredTextStyle));
        }
        return InputResult.IGNORED;
    }

    @Nullable
    public class_2583 getTextStyleAt(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            int xOffset = TextAlignment.getTextOffsetX(this.horizontalAlignment, this.getWidth(), this.text.method_30937());
            return class_310.method_1551().field_1772.method_27527().method_27489((class_5348)this.text, x - xOffset);
        }
        return null;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, Math.max(8, y));
    }

    public int getColor() {
        return this.color != null ? this.color.intValue() : LibGui.getGuiStyle().getTitleColor();
    }

    public WLabel setColor(int color) {
        this.color = color;
        return this;
    }

    public boolean getDrawShadows() {
        return this.drawShadows == null ? LibGui.getGuiStyle().isFontShadow() : this.drawShadows.booleanValue();
    }

    public WLabel setDrawShadows(boolean drawShadows) {
        this.drawShadows = drawShadows;
        return this;
    }

    public class_2561 getText() {
        return this.text;
    }

    public WLabel setText(class_2561 text) {
        this.text = text;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WLabel setHorizontalAlignment(HorizontalAlignment align) {
        this.horizontalAlignment = align;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WLabel setVerticalAlignment(VerticalAlignment align) {
        this.verticalAlignment = align;
        return this;
    }

    @Override
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, this.text);
    }
}

