/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.widget;

import dev.tr7zw.trender.gui.GuiDescription;
import dev.tr7zw.trender.gui.impl.VisualLogger;
import dev.tr7zw.trender.gui.widget.WPanelWithInsets;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.Insets;
import java.util.ArrayList;
import java.util.List;

public class WGridPanel
extends WPanelWithInsets {
    private static final VisualLogger LOGGER = new VisualLogger(WGridPanel.class);
    protected int grid = 18;
    protected int horizontalGap = 0;
    protected int verticalGap = 0;
    private final List<WWidget> requiresHost = new ArrayList<WWidget>();

    public WGridPanel() {
    }

    public WGridPanel(int gridSize) {
        this.grid = gridSize;
    }

    public WGridPanel setGaps(int horizontalGap, int verticalGap) {
        if (!this.children.isEmpty()) {
            LOGGER.warn("You can only change gaps before adding children to a WGridPanel", new Object[0]);
            return this;
        }
        this.horizontalGap = horizontalGap;
        this.verticalGap = verticalGap;
        return this;
    }

    public void add(WWidget w, int x, int y) {
        this.add(w, x, y, 1, 1);
    }

    public void add(WWidget w, int x, int y, int width, int height) {
        this.children.add(w);
        w.setParent(this);
        w.setLocation(x * (this.grid + this.horizontalGap) + this.insets.left(), y * (this.grid + this.verticalGap) + this.insets.top());
        if (w.canResize()) {
            w.setSize((width - 1) * (this.grid + this.horizontalGap) + this.grid, (height - 1) * (this.grid + this.verticalGap) + this.grid);
        }
        if (this.host != null) {
            w.setHost(this.host);
        } else {
            this.requiresHost.add(w);
        }
        this.expandToFit(w, this.insets);
    }

    @Override
    public WGridPanel setInsets(Insets insets) {
        super.setInsets(insets);
        return this;
    }

    @Override
    public void setHost(GuiDescription host) {
        super.setHost(host);
        this.setRequiredHosts(host);
    }

    private void setRequiredHosts(GuiDescription host) {
        for (WWidget widget : this.requiresHost) {
            widget.setHost(host);
        }
        this.requiresHost.clear();
    }
}

