/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.trender.gui.client.PoseStackHelper;
import dev.tr7zw.trender.gui.impl.client.VanillaShaders;
import dev.tr7zw.trender.gui.impl.mixin.client.DrawContextAccessor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class RenderContext
implements PoseStackHelper {
    private static final class_310 minecraft = class_310.method_1551();
    private final class_332 guiGraphics;

    @Override
    public class_4587 getPose() {
        return this.guiGraphics.method_51448();
    }

    public void drawSpecial(Consumer<class_4597> consumer) {
        consumer.accept((class_4597)this.guiGraphics.method_51450());
        this.guiGraphics.method_51450().method_22993();
    }

    public void blit(class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        this.guiGraphics.method_25291(atlasLocation, x, y, 0, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    public void blit(class_2960 atlasLocation, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        this.blit(atlasLocation, x, y, uOffset, vOffset, uWidth, vHeight, 64, 64);
    }

    public void blit(class_2960 atlasLocation, int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.guiGraphics.method_25291(atlasLocation, x, y, blitOffset, uOffset, vOffset, uWidth, vHeight, textureWidth, textureHeight);
    }

    public void blitSprite(class_2960 texture, int x, int y, int width, int height, int sliceSide, int sliceTop, int txtWidth, int txtHeight) {
        this.guiGraphics.method_52706(texture, x, y, width, height);
    }

    public void blitSpriteLegacy(class_2960 texture, int x, int y, int width, int height, int sliceSide, int sliceTop, int txtWidth, int txtHeight) {
        this.blitNineSliced(texture, x, y, width, height, sliceSide, sliceTop, sliceSide, sliceTop, txtWidth, txtHeight, txtWidth, txtHeight);
    }

    private void blitNineSliced(class_2960 atlasLocation, int x, int y, int width, int height, int leftSliceWidth, int topSliceHeight, int rightSliceWidth, int bottomSliceHeight, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        leftSliceWidth = Math.min(leftSliceWidth, width / 2);
        rightSliceWidth = Math.min(rightSliceWidth, width / 2);
        topSliceHeight = Math.min(topSliceHeight, height / 2);
        bottomSliceHeight = Math.min(bottomSliceHeight, height / 2);
        if (width == uWidth && height == vHeight) {
            this.blit(atlasLocation, x, y, 0.0f, 0.0f, width, height, textureWidth, textureHeight);
        } else if (height == vHeight) {
            this.blit(atlasLocation, x, y, 0.0f, 0.0f, leftSliceWidth, height, textureWidth, textureHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, height, leftSliceWidth, 0, uWidth - rightSliceWidth - leftSliceWidth, vHeight, textureWidth, textureHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y, uWidth - rightSliceWidth, 0.0f, rightSliceWidth, height, textureWidth, textureHeight);
        } else if (width == uWidth) {
            this.blit(atlasLocation, x, y, 0.0f, 0.0f, width, topSliceHeight, textureWidth, textureHeight);
            this.blitRepeating(atlasLocation, x, y + topSliceHeight, width, height - bottomSliceHeight - topSliceHeight, 0, topSliceHeight, uWidth, vHeight - bottomSliceHeight - topSliceHeight, textureWidth, textureHeight);
            this.blit(atlasLocation, x, y + height - bottomSliceHeight, 0.0f, vHeight - bottomSliceHeight, width, bottomSliceHeight, textureWidth, textureHeight);
        } else {
            this.blit(atlasLocation, x, y, 0.0f, 0.0f, leftSliceWidth, topSliceHeight, textureWidth, textureHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, topSliceHeight, leftSliceWidth, 0, uWidth - rightSliceWidth - leftSliceWidth, topSliceHeight, textureWidth, textureHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y, uWidth - rightSliceWidth, 0.0f, rightSliceWidth, topSliceHeight, textureWidth, textureHeight);
            this.blit(atlasLocation, x, y + height - bottomSliceHeight, 0.0f, vHeight - bottomSliceHeight, leftSliceWidth, bottomSliceHeight, textureWidth, textureHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y + height - bottomSliceHeight, width - rightSliceWidth - leftSliceWidth, bottomSliceHeight, leftSliceWidth, vHeight - bottomSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, bottomSliceHeight, textureWidth, textureHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y + height - bottomSliceHeight, uWidth - rightSliceWidth, vHeight - bottomSliceHeight, rightSliceWidth, bottomSliceHeight, textureWidth, textureHeight);
            this.blitRepeating(atlasLocation, x, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, 0, topSliceHeight, leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, textureWidth, textureHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y + topSliceHeight, width - rightSliceWidth - leftSliceWidth, height - bottomSliceHeight - topSliceHeight, leftSliceWidth, topSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, textureWidth, textureHeight);
            this.blitRepeating(atlasLocation, x + width - rightSliceWidth, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, uWidth - rightSliceWidth, topSliceHeight, rightSliceWidth, vHeight - bottomSliceHeight - topSliceHeight, textureWidth, textureHeight);
        }
    }

    private void blitRepeating(class_2960 atlasLocation, int x, int y, int width, int height, int uOffset, int vOffset, int sourceWidth, int sourceHeight, int textureWidth, int textureHeight) {
        int i = x;
        IntIterator intIterator = RenderContext.slices(width, sourceWidth);
        while (intIterator.hasNext()) {
            int j = intIterator.nextInt();
            int k = (sourceWidth - j) / 2;
            int l = y;
            IntIterator intIterator2 = RenderContext.slices(height, sourceHeight);
            while (intIterator2.hasNext()) {
                int m = intIterator2.nextInt();
                int n = (sourceHeight - m) / 2;
                this.blit(atlasLocation, i, l, uOffset + k, vOffset + n, j, m, textureWidth, textureHeight);
                l += m;
            }
            i += j;
        }
    }

    private static IntIterator slices(int target, int total) {
        if (total == 0) {
            return new IntIterator(){

                public boolean hasNext() {
                    return false;
                }

                public int nextInt() {
                    return 0;
                }
            };
        }
        int i = RenderContext.positiveCeilDiv(target, total);
        return new Divisor(target, i);
    }

    private static int positiveCeilDiv(int x, int y) {
        return -Math.floorDiv(-x, y);
    }

    public void blitSprite(class_2960 texture, int x, int y, int width, int height, int color) {
        this.guiGraphics.method_52707(texture, x, y, width, height, color);
    }

    public void renderTooltip(class_327 font, List<class_5481> split, int x, int y) {
        this.guiGraphics.method_51447(font, split, x, y);
    }

    public void renderTooltip(class_327 font, class_5250 translatable, int x, int y) {
        this.guiGraphics.method_51438(font, (class_2561)translatable, x, y);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.guiGraphics.method_25294(minX, minY, maxX, maxY, color);
    }

    public void invertedRect(int x, int y, int width, int height) {
        Matrix4f model = this.getPose().method_23760().method_23761();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(VanillaShaders.POSITION);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        class_287 buffer = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        buffer.method_22918(model, (float)x, (float)(y + height), 0.0f);
        buffer.method_22918(model, (float)(x + width), (float)(y + height), 0.0f);
        buffer.method_22918(model, (float)(x + width), (float)y, 0.0f);
        buffer.method_22918(model, (float)x, (float)y, 0.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableColorLogicOp();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderFakeItem(class_1799 itemStack, int x, int y) {
        this.guiGraphics.method_51445(itemStack, x, y);
    }

    public void renderItemDecorations(class_327 font, class_1799 itemStack, int x, int y) {
        this.guiGraphics.method_51431(font, itemStack, x, y);
    }

    public void renderItem(class_1657 player, class_1799 itemStack, int x, int y, int seed) {
        this.guiGraphics.method_51423((class_1309)player, itemStack, x, y, seed);
    }

    public void drawString(class_327 font, class_2561 name, int x, int y, int color) {
        this.guiGraphics.method_27535(font, name, x, y, color);
    }

    public void drawCenteredString(class_327 font, class_2561 name, int x, int y, int color) {
        this.guiGraphics.method_27534(font, name, x, y, color);
    }

    public void drawString(class_327 textRenderer, String s, int x, int y, int color, boolean dropShadow) {
        this.guiGraphics.method_51433(textRenderer, s, x, y, color, dropShadow);
    }

    public void drawString(class_327 textRenderer, class_5481 text, int x, int y, int color, boolean dropShadow) {
        this.guiGraphics.method_51430(textRenderer, text, x, y, color, dropShadow);
    }

    public void drawString(class_327 textRenderer, @Nullable class_2561 suggestion, int x, int y, int suggestionColor, boolean b) {
        this.guiGraphics.method_51439(textRenderer, suggestion, x, y, suggestionColor, b);
    }

    public void renderComponentHoverEffect(class_327 font, @Nullable class_2583 textStyle, int x, int y) {
        this.guiGraphics.method_51441(font, textStyle, x, y);
    }

    public void flush() {
        this.guiGraphics.method_51452();
    }

    public class_4597.class_4598 getVertexConsumers() {
        return ((DrawContextAccessor)this.guiGraphics).libgui$getVertexConsumers();
    }

    @Generated
    public RenderContext(class_332 guiGraphics) {
        this.guiGraphics = guiGraphics;
    }

    @Generated
    public class_332 getGuiGraphics() {
        return this.guiGraphics;
    }

    private static class Divisor
    implements IntIterator {
        private final int denominator;
        private final int quotient;
        private final int mod;
        private int returnedParts;
        private int remainder;

        public Divisor(int numerator, int denominator) {
            this.denominator = denominator;
            if (denominator > 0) {
                this.quotient = numerator / denominator;
                this.mod = numerator % denominator;
            } else {
                this.quotient = 0;
                this.mod = 0;
            }
        }

        public boolean hasNext() {
            return this.returnedParts < this.denominator;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int i = this.quotient;
            this.remainder += this.mod;
            if (this.remainder >= this.denominator) {
                this.remainder -= this.denominator;
                ++i;
            }
            ++this.returnedParts;
            return i;
        }
    }
}

