/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui;

import dev.tr7zw.transition.mc.ItemUtil;
import dev.tr7zw.trender.gui.EmptyInventory;
import dev.tr7zw.trender.gui.GuiDescription;
import dev.tr7zw.trender.gui.PropertyDelegateHolder;
import dev.tr7zw.trender.gui.ValidatedSlot;
import dev.tr7zw.trender.gui.client.BackgroundPainter;
import dev.tr7zw.trender.gui.networking.NetworkSide;
import dev.tr7zw.trender.gui.widget.WGridPanel;
import dev.tr7zw.trender.gui.widget.WPanel;
import dev.tr7zw.trender.gui.widget.WPlayerInvPanel;
import dev.tr7zw.trender.gui.widget.WWidget;
import dev.tr7zw.trender.gui.widget.data.HorizontalAlignment;
import dev.tr7zw.trender.gui.widget.data.Insets;
import dev.tr7zw.trender.gui.widget.data.Vec2i;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_3954;
import net.minecraft.class_634;
import org.jetbrains.annotations.Nullable;

public class SyncedGuiDescription
extends class_1703
implements GuiDescription {
    protected class_1263 blockInventory;
    protected class_1661 playerInventory;
    protected class_1937 world;
    protected class_3913 propertyDelegate;
    protected WPanel rootPanel = new WGridPanel().setInsets(Insets.ROOT_PANEL);
    protected Integer titleColor = null;
    protected boolean fullscreen = false;
    protected boolean titleVisible = true;
    protected HorizontalAlignment titleAlignment = HorizontalAlignment.LEFT;
    protected WWidget focus;
    private Vec2i titlePos = new Vec2i(8, 6);
    private boolean useDefaultRootBackground = true;

    public SyncedGuiDescription(class_3917<?> type, int syncId, class_1661 playerInventory) {
        super(type, syncId);
        this.blockInventory = null;
        this.playerInventory = playerInventory;
        this.world = playerInventory.field_7546.method_37908();
        this.propertyDelegate = null;
    }

    public SyncedGuiDescription(class_3917<?> type, int syncId, class_1661 playerInventory, @Nullable class_1263 blockInventory, @Nullable class_3913 propertyDelegate) {
        super(type, syncId);
        this.blockInventory = blockInventory;
        this.playerInventory = playerInventory;
        this.world = playerInventory.field_7546.method_37908();
        this.propertyDelegate = propertyDelegate;
        if (propertyDelegate != null && propertyDelegate.method_17389() > 0) {
            this.method_17360(propertyDelegate);
        }
        if (blockInventory != null) {
            blockInventory.method_5435(playerInventory.field_7546);
        }
    }

    @Override
    public WPanel getRootPanel() {
        return this.rootPanel;
    }

    @Override
    public int getTitleColor() {
        return this.titleColor != null ? this.titleColor.intValue() : this.getStyle().getTitleColor();
    }

    @Override
    public SyncedGuiDescription setRootPanel(WPanel panel) {
        this.rootPanel = panel;
        return this;
    }

    @Override
    public SyncedGuiDescription setTitleColor(int color) {
        this.titleColor = color;
        return this;
    }

    @Override
    public void addPainters() {
        if (this.rootPanel != null && !this.fullscreen && this.getUseDefaultRootBackground()) {
            this.rootPanel.setBackgroundPainter(BackgroundPainter.VANILLA);
        }
    }

    @Override
    public boolean getUseDefaultRootBackground() {
        return this.useDefaultRootBackground;
    }

    @Override
    public void setUseDefaultRootBackground(boolean useDefaultRootBackground) {
        this.useDefaultRootBackground = useDefaultRootBackground;
    }

    @Override
    public void addSlotPeer(ValidatedSlot slot) {
        this.method_7621(slot);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 result = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            result = slotStack.method_7972();
            if (this.blockInventory != null ? (slot.field_7871 == this.blockInventory ? !this.insertItem(slotStack, (class_1263)this.playerInventory, true, player) : !this.insertItem(slotStack, this.blockInventory, false, player)) : !this.swapHotbar(slotStack, index, (class_1263)this.playerInventory, player)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return result;
    }

    private boolean insertIntoExisting(class_1799 toInsert, class_1735 slot, class_1657 player) {
        class_1799 curSlotStack = slot.method_7677();
        if (!curSlotStack.method_7960() && ItemUtil.isSame((class_1799)toInsert, (class_1799)curSlotStack) && slot.method_7680(toInsert)) {
            int maxAmount;
            int combinedAmount = curSlotStack.method_7947() + toInsert.method_7947();
            if (combinedAmount <= (maxAmount = Math.min(toInsert.method_7914(), slot.method_7676(toInsert)))) {
                toInsert.method_7939(0);
                curSlotStack.method_7939(combinedAmount);
                slot.method_7668();
                return true;
            }
            if (curSlotStack.method_7947() < maxAmount) {
                toInsert.method_7934(maxAmount - curSlotStack.method_7947());
                curSlotStack.method_7939(maxAmount);
                slot.method_7668();
                return true;
            }
        }
        return false;
    }

    private boolean insertIntoEmpty(class_1799 toInsert, class_1735 slot) {
        class_1799 curSlotStack = slot.method_7677();
        if (curSlotStack.method_7960() && slot.method_7680(toInsert)) {
            if (toInsert.method_7947() > slot.method_7676(toInsert)) {
                slot.method_53512(toInsert.method_7971(slot.method_7676(toInsert)));
            } else {
                slot.method_53512(toInsert.method_7971(toInsert.method_7947()));
            }
            slot.method_7668();
            return true;
        }
        return false;
    }

    private boolean insertItem(class_1799 toInsert, class_1263 inventory, boolean walkBackwards, class_1657 player) {
        boolean inserted;
        block19: {
            class_1735 curSlot;
            int i;
            ArrayList<class_1735> inventorySlots = new ArrayList<class_1735>();
            for (class_1735 slot : this.field_7761) {
                if (slot.field_7871 != inventory) continue;
                inventorySlots.add(slot);
            }
            if (inventorySlots.isEmpty()) {
                return false;
            }
            inserted = false;
            if (walkBackwards) {
                for (i = inventorySlots.size() - 1; i >= 0; --i) {
                    curSlot = (class_1735)inventorySlots.get(i);
                    if (this.insertIntoExisting(toInsert, curSlot, player)) {
                        inserted = true;
                    }
                    if (!toInsert.method_7960()) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i < inventorySlots.size(); ++i) {
                    curSlot = (class_1735)inventorySlots.get(i);
                    if (this.insertIntoExisting(toInsert, curSlot, player)) {
                        inserted = true;
                    }
                    if (!toInsert.method_7960()) {
                        continue;
                    }
                    break;
                }
            }
            if (toInsert.method_7960()) break block19;
            if (walkBackwards) {
                for (i = inventorySlots.size() - 1; i >= 0; --i) {
                    curSlot = (class_1735)inventorySlots.get(i);
                    if (this.insertIntoEmpty(toInsert, curSlot)) {
                        inserted = true;
                    }
                    if (!toInsert.method_7960()) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i < inventorySlots.size(); ++i) {
                    curSlot = (class_1735)inventorySlots.get(i);
                    if (this.insertIntoEmpty(toInsert, curSlot)) {
                        inserted = true;
                    }
                    if (!toInsert.method_7960()) {
                        continue;
                    }
                    break;
                }
            }
        }
        return inserted;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean swapHotbar(class_1799 toInsert, int slotNumber, class_1263 inventory, class_1657 player) {
        ArrayList<class_1735> storageSlots = new ArrayList<class_1735>();
        ArrayList<class_1735> hotbarSlots = new ArrayList<class_1735>();
        boolean swapToStorage = true;
        boolean inserted = false;
        for (class_1735 slot : this.field_7761) {
            if (slot.field_7871 != inventory || !(slot instanceof ValidatedSlot)) continue;
            ValidatedSlot validated = (ValidatedSlot)slot;
            int index = validated.getInventoryIndex();
            if (class_1661.method_7380((int)index)) {
                hotbarSlots.add(slot);
                continue;
            }
            storageSlots.add(slot);
            if (slot.field_7874 != slotNumber) continue;
            swapToStorage = false;
        }
        if (storageSlots.isEmpty() || hotbarSlots.isEmpty()) {
            return false;
        }
        if (swapToStorage) {
            int i;
            for (i = 0; i < storageSlots.size(); ++i) {
                curSlot = (class_1735)storageSlots.get(i);
                if (this.insertIntoExisting(toInsert, curSlot, player)) {
                    inserted = true;
                }
                if (toInsert.method_7960()) break;
            }
            if (toInsert.method_7960()) return inserted;
            for (i = 0; i < storageSlots.size(); ++i) {
                curSlot = (class_1735)storageSlots.get(i);
                if (this.insertIntoEmpty(toInsert, curSlot)) {
                    inserted = true;
                }
                if (toInsert.method_7960()) return inserted;
            }
            return inserted;
        } else {
            int i;
            for (i = 0; i < hotbarSlots.size(); ++i) {
                curSlot = (class_1735)hotbarSlots.get(i);
                if (this.insertIntoExisting(toInsert, curSlot, player)) {
                    inserted = true;
                }
                if (toInsert.method_7960()) break;
            }
            if (toInsert.method_7960()) return inserted;
            for (i = 0; i < hotbarSlots.size(); ++i) {
                curSlot = (class_1735)hotbarSlots.get(i);
                if (this.insertIntoEmpty(toInsert, curSlot)) {
                    inserted = true;
                }
                if (toInsert.method_7960()) return inserted;
            }
        }
        return inserted;
    }

    @Override
    @Nullable
    public class_3913 getPropertyDelegate() {
        return this.propertyDelegate;
    }

    @Override
    public GuiDescription setPropertyDelegate(class_3913 delegate) {
        this.propertyDelegate = delegate;
        return this;
    }

    public WPlayerInvPanel createPlayerInventoryPanel() {
        return new WPlayerInvPanel(this.playerInventory);
    }

    public WPlayerInvPanel createPlayerInventoryPanel(boolean hasLabel) {
        return new WPlayerInvPanel(this.playerInventory, hasLabel);
    }

    public WPlayerInvPanel createPlayerInventoryPanel(WWidget label) {
        return new WPlayerInvPanel(this.playerInventory, label);
    }

    public static class_1263 getBlockInventory(class_3914 ctx) {
        return SyncedGuiDescription.getBlockInventory(ctx, () -> EmptyInventory.INSTANCE);
    }

    public static class_1263 getBlockInventory(class_3914 ctx, int size) {
        return SyncedGuiDescription.getBlockInventory(ctx, () -> new class_1277(size));
    }

    private static class_1263 getBlockInventory(class_3914 ctx, Supplier<class_1263> fallback) {
        return ctx.method_17395((world, pos) -> {
            class_3954 inventoryProvider;
            class_1278 inventory;
            class_2680 state = world.method_8320(pos);
            class_2248 b = state.method_26204();
            if (b instanceof class_3954 && (inventory = (inventoryProvider = (class_3954)b).method_17680(state, (class_1936)world, pos)) != null) {
                return inventory;
            }
            class_2586 be = world.method_8321(pos);
            if (be != null) {
                if (be instanceof class_3954) {
                    class_3954 inventoryProvider2 = (class_3954)be;
                    class_1278 inventory2 = inventoryProvider2.method_17680(state, (class_1936)world, pos);
                    if (inventory2 != null) {
                        return inventory2;
                    }
                } else if (be instanceof class_1263) {
                    class_1263 inventory3 = (class_1263)be;
                    return inventory3;
                }
            }
            return (class_1263)fallback.get();
        }).orElseGet(fallback);
    }

    public static class_3913 getBlockPropertyDelegate(class_3914 ctx) {
        return (class_3913)ctx.method_17395((world, pos) -> {
            class_2586 be = world.method_8321(pos);
            if (be instanceof PropertyDelegateHolder) {
                PropertyDelegateHolder holder = (PropertyDelegateHolder)be;
                return holder.getPropertyDelegate();
            }
            return new class_3919(0);
        }).orElse(new class_3919(0));
    }

    public static class_3913 getBlockPropertyDelegate(class_3914 ctx, int size) {
        return (class_3913)ctx.method_17395((world, pos) -> {
            class_2586 be = world.method_8321(pos);
            if (be instanceof PropertyDelegateHolder) {
                PropertyDelegateHolder holder = (PropertyDelegateHolder)be;
                return holder.getPropertyDelegate();
            }
            return new class_3919(size);
        }).orElse(new class_3919(size));
    }

    public boolean method_7597(class_1657 entity) {
        return this.blockInventory != null ? this.blockInventory.method_5443(entity) : true;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.blockInventory != null) {
            this.blockInventory.method_5432(player);
        }
    }

    @Override
    public boolean isFocused(WWidget widget) {
        return this.focus == widget;
    }

    @Override
    public WWidget getFocus() {
        return this.focus;
    }

    @Override
    public void requestFocus(WWidget widget) {
        if (this.focus == widget) {
            return;
        }
        if (!widget.canFocus()) {
            return;
        }
        if (this.focus != null) {
            this.focus.onFocusLost();
        }
        this.focus = widget;
        this.focus.onFocusGained();
    }

    @Override
    public void releaseFocus(WWidget widget) {
        if (this.focus == widget) {
            this.focus = null;
            widget.onFocusLost();
        }
    }

    @Override
    public boolean isFullscreen() {
        return this.fullscreen;
    }

    @Override
    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    @Override
    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    @Override
    public void setTitleVisible(boolean titleVisible) {
        this.titleVisible = titleVisible;
    }

    @Override
    public HorizontalAlignment getTitleAlignment() {
        return this.titleAlignment;
    }

    @Override
    public void setTitleAlignment(HorizontalAlignment titleAlignment) {
        this.titleAlignment = titleAlignment;
    }

    @Override
    public Vec2i getTitlePos() {
        return this.titlePos;
    }

    @Override
    public void setTitlePos(Vec2i titlePos) {
        this.titlePos = titlePos;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public final NetworkSide getNetworkSide() {
        return this.world instanceof class_3218 ? NetworkSide.SERVER : NetworkSide.CLIENT;
    }

    public final Consumer<class_2596<?>> getPacketSender() {
        if (this.getNetworkSide() == NetworkSide.SERVER) {
            return arg_0 -> ((class_3244)((class_3222)this.playerInventory.field_7546).field_13987).method_14364(arg_0);
        }
        return arg_0 -> ((class_634)class_310.method_1551().method_1562()).method_52787(arg_0);
    }
}

