/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterCreeperAlertCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterDiamondAlertCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSeekDiamondGoal;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerEntityAccessor {
    @Unique
    private static final class_2940<class_2487> HAMSTER_SHOULDER_ENTITY = class_2945.method_12791(class_1657.class, (class_2941)class_2943.field_13318);
    @Unique
    private static final int CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final List<String> DISMOUNT_MESSAGE_KEYS = Arrays.asList("message.adorablehamsterpets.dismount.1", "message.adorablehamsterpets.dismount.2", "message.adorablehamsterpets.dismount.3", "message.adorablehamsterpets.dismount.4", "message.adorablehamsterpets.dismount.5", "message.adorablehamsterpets.dismount.6");
    @Unique
    private int adorablehamsterpets$diamondCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$creeperCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$diamondSoundCooldownTicks = 0;
    @Unique
    private int adorablehamsterpets$creeperSoundCooldownTicks = 0;
    @Unique
    private String adorablehamsterpets$lastDismountMessageKey = "";
    @Unique
    private boolean adorablehamsterpets$isDiamondAlertConditionMet = false;
    @Unique
    private int adorablehamsterpets$lastGoldMessageIndex = -1;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$initDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] PlayerEntityMixin initDataTracker is RUNNING for entity {}.", (Object)this.method_5628());
        builder.method_56912(HAMSTER_SHOULDER_ENTITY, (Object)new class_2487());
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$writeNbt(class_2487 nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] PlayerEntityMixin writeNbt is RUNNING for entity {}.", (Object)this.method_5628());
        if (!this.getHamsterShoulderEntity().method_33133()) {
            nbt.method_10566("ShoulderHamster", (class_2520)this.getHamsterShoulderEntity());
        }
        if (this.adorablehamsterpets$lastGoldMessageIndex != -1) {
            nbt.method_10569("LastGoldMessageIndex", this.adorablehamsterpets$lastGoldMessageIndex);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$readNbt(class_2487 nbt, CallbackInfo ci) {
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] PlayerEntityMixin readNbt is RUNNING for entity {}.", (Object)this.method_5628());
        if (nbt.method_10573("ShoulderHamster", 10)) {
            this.setHamsterShoulderEntity(nbt.method_10562("ShoulderHamster"));
        }
        this.adorablehamsterpets$lastGoldMessageIndex = nbt.method_10573("LastGoldMessageIndex", 3) ? nbt.method_10550("LastGoldMessageIndex") : -1;
    }

    @Inject(method={"remove(Lnet/minecraft/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onRemove(class_1297.class_5529 reason, CallbackInfo ci) {
        if (!this.method_37908().method_8608()) {
            HamsterRenderTracker.onPlayerDisconnect(this.method_5667());
        }
    }

    @Override
    @Unique
    public class_2487 getHamsterShoulderEntity() {
        return (class_2487)this.method_5841().method_12789(HAMSTER_SHOULDER_ENTITY);
    }

    @Override
    @Unique
    public void setHamsterShoulderEntity(class_2487 nbt) {
        this.method_5841().method_12778(HAMSTER_SHOULDER_ENTITY, (Object)nbt);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onTick(CallbackInfo ci) {
        class_2487 shoulderNbt;
        class_1657 self = (class_1657)this;
        class_1937 world = self.method_37908();
        if (world.field_9236) {
            return;
        }
        class_5819 random = world.method_8409();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (this.adorablehamsterpets$diamondSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$diamondSoundCooldownTicks;
        }
        if (this.adorablehamsterpets$creeperSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$creeperSoundCooldownTicks;
        }
        if (!(shoulderNbt = this.getHamsterShoulderEntity()).method_33133()) {
            if (config.enableShoulderDiamondDetection) {
                ++this.adorablehamsterpets$diamondCheckTimer;
                if (this.adorablehamsterpets$diamondCheckTimer >= 20) {
                    this.adorablehamsterpets$diamondCheckTimer = 0;
                    if (this.isDiamondNearby(self, (Double)config.shoulderDiamondDetectionRadius.get())) {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = true;
                        if (this.adorablehamsterpets$diamondSoundCooldownTicks == 0) {
                            world.method_8396(null, self.method_24515(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, random), class_3419.field_15254, 2.5f, 1.0f);
                            self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.diamond_nearby").method_27692(class_124.field_1075), true);
                            this.adorablehamsterpets$diamondSoundCooldownTicks = random.method_39332(140, 200);
                            ((HamsterDiamondAlertCriterion)((Object)ModCriteria.HAMSTER_DIAMOND_ALERT_TRIGGERED.get())).trigger((class_3222)self);
                        }
                    } else {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                    }
                }
            }
            if (config.enableShoulderCreeperDetection) {
                ++this.adorablehamsterpets$creeperCheckTimer;
                if (this.adorablehamsterpets$creeperCheckTimer >= 20) {
                    this.adorablehamsterpets$creeperCheckTimer = 0;
                    if (this.creeperSeesPlayer(self, (Double)config.shoulderCreeperDetectionRadius.get()) && this.adorablehamsterpets$creeperSoundCooldownTicks == 0) {
                        world.method_8396(null, self.method_24515(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CREEPER_DETECT_SOUNDS, random), class_3419.field_15254, 1.0f, 1.0f);
                        self.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.creeper_detected").method_27692(class_124.field_1061), true);
                        this.adorablehamsterpets$creeperSoundCooldownTicks = random.method_39332(100, 160);
                        ((HamsterCreeperAlertCriterion)((Object)ModCriteria.HAMSTER_CREEPER_ALERT_TRIGGERED.get())).trigger((class_3222)self);
                    }
                }
            }
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$dismountShoulderHamster() {
        AdorableHamsterPets.LOGGER.debug("[AHP DEBUG] DISMOUNT: adorablehamsterpets$dismountShoulderHamster() was called via payload.");
        class_1657 self = (class_1657)this;
        class_1937 world = self.method_37908();
        if (world.field_9236) {
            return;
        }
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)self;
        class_2487 shoulderNbt = playerAccessor.getHamsterShoulderEntity();
        class_5819 random = world.method_8409();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (!shoulderNbt.method_33133()) {
            HamsterEntity.spawnFromNbt((class_3218)world, self, shoulderNbt, this.adorablehamsterpets$isDiamondAlertConditionMet);
            this.adorablehamsterpets$isDiamondAlertConditionMet = false;
            this.setHamsterShoulderEntity(new class_2487());
            world.method_8396(null, self.method_24515(), (class_3414)ModSounds.HAMSTER_DISMOUNT.get(), class_3419.field_15248, 0.7f, 1.0f + random.method_43057() * 0.2f);
            if (config.enableShoulderDismountMessages && !DISMOUNT_MESSAGE_KEYS.isEmpty()) {
                String chosenKey;
                if (DISMOUNT_MESSAGE_KEYS.size() == 1) {
                    chosenKey = DISMOUNT_MESSAGE_KEYS.get(0);
                } else {
                    ArrayList<String> availableKeys = new ArrayList<String>(DISMOUNT_MESSAGE_KEYS);
                    availableKeys.remove(this.adorablehamsterpets$lastDismountMessageKey);
                    chosenKey = availableKeys.isEmpty() ? this.adorablehamsterpets$lastDismountMessageKey : (String)availableKeys.get(random.method_43048(availableKeys.size()));
                }
                self.method_7353((class_2561)class_2561.method_43471((String)chosenKey), true);
                this.adorablehamsterpets$lastDismountMessageKey = chosenKey;
            }
        }
    }

    @Unique
    private boolean isDiamondNearby(class_1657 player, double radius) {
        class_1937 world = player.method_37908();
        class_2338 center = player.method_24515();
        int intRadius = (int)Math.ceil(radius);
        ArrayList<class_2338> exposedOres = new ArrayList<class_2338>();
        ArrayList<class_2338> buriedOres = new ArrayList<class_2338>();
        for (class_2338 checkPos : class_2338.method_10097((class_2338)center.method_10069(-intRadius, -intRadius, -intRadius), (class_2338)center.method_10069(intRadius, intRadius, intRadius))) {
            class_2680 state;
            if (!(checkPos.method_10262((class_2382)center) <= radius * radius) || !(state = world.method_8320(checkPos)).method_27852(class_2246.field_10442) && !state.method_27852(class_2246.field_29029)) continue;
            if (HamsterSeekDiamondGoal.isOreExposed(checkPos, world)) {
                exposedOres.add(checkPos.method_10062());
                continue;
            }
            buriedOres.add(checkPos.method_10062());
        }
        return !exposedOres.isEmpty() || !buriedOres.isEmpty();
    }

    @Unique
    private boolean creeperSeesPlayer(class_1657 player, double radius) {
        class_238 searchBox;
        class_1937 world = player.method_37908();
        List nearbyCreepers = world.method_8390(class_1548.class, searchBox = new class_238(player.method_19538().method_1023(radius, radius, radius), player.method_19538().method_1031(radius, radius, radius)), creeper -> creeper.method_5805() && creeper.method_5968() == player && class_1301.field_6154.test(creeper));
        return !nearbyCreepers.isEmpty();
    }

    @Override
    @Unique
    public int ahp_getLastGoldMessageIndex() {
        return this.adorablehamsterpets$lastGoldMessageIndex;
    }

    @Override
    @Unique
    public void ahp_setLastGoldMessageIndex(int index) {
        this.adorablehamsterpets$lastGoldMessageIndex = index;
    }
}

