/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.feature;

import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.entity.client.ModModelLayers;
import net.dawson.adorablehamsterpets.entity.client.model.HamsterShoulderModel;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class HamsterShoulderFeatureRenderer
extends class_3887<class_742, class_591<class_742>> {
    private static final float BABY_SCALE = 0.4f;
    private static final float ADULT_SCALE = 0.7f;
    private static final float BABY_Y_OFFSET_SNEAKING = -0.55f;
    private static final float BABY_Y_OFFSET_STANDING = -0.6f;
    private static final float ADULT_Y_OFFSET_SNEAKING = -0.85f;
    private static final float ADULT_Y_OFFSET_STANDING = -1.05f;
    private final class_5599 modelLoader;
    @Nullable
    private HamsterShoulderModel hamsterShoulderModel;
    @Nullable
    private class_630 closedEyesPart;

    public HamsterShoulderFeatureRenderer(class_3883<class_742, class_591<class_742>> context, class_5599 modelLoader) {
        super(context);
        this.modelLoader = modelLoader;
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_2487 shoulderNbt;
        if (this.hamsterShoulderModel == null) {
            this.initializeModels();
        }
        if ((shoulderNbt = ((PlayerEntityAccessor)player).getHamsterShoulderEntity()).method_33133() || this.hamsterShoulderModel == null) {
            return;
        }
        Optional<HamsterShoulderData> shoulderDataOpt = HamsterShoulderData.fromNbt(shoulderNbt);
        if (shoulderDataOpt.isEmpty()) {
            return;
        }
        HamsterShoulderData shoulderData = shoulderDataOpt.get();
        this.setCheekVisibility(shoulderData);
        if (this.closedEyesPart != null) {
            this.closedEyesPart.field_3665 = false;
        }
        this.renderShoulderHamster(matrices, vertexConsumers, light, player, shoulderData);
    }

    private void initializeModels() {
        try {
            this.hamsterShoulderModel = new HamsterShoulderModel(this.modelLoader.method_32072(ModModelLayers.HAMSTER_SHOULDER_LAYER));
            this.closedEyesPart = this.hamsterShoulderModel.root.method_32086("body_parent").method_32086("body_child").method_32086("head_parent").method_32086("head_child").method_32086("closed_eyes");
        }
        catch (Exception e) {
            AdorableHamsterPets.LOGGER.error("[ShoulderRender] Failed to initialize shoulder model lazily. Feature will be disabled.", (Throwable)e);
        }
    }

    private void renderShoulderHamster(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 player, HamsterShoulderData shoulderData) {
        float scaleFactor;
        matrices.method_22903();
        boolean isBaby = shoulderData.breedingAge() < 0;
        float f = scaleFactor = isBaby ? 0.4f : 0.7f;
        float yOffset = player.method_18276() ? (isBaby ? -0.55f : -0.85f) : (isBaby ? -0.6f : -1.05f);
        float xOffset = -0.4f;
        matrices.method_46416(xOffset, yOffset, 0.0f);
        matrices.method_22905(scaleFactor, scaleFactor, scaleFactor);
        HamsterVariant variant = HamsterVariant.byId(shoulderData.variantId());
        class_2960 baseTextureId = this.getTextureId(variant.getBaseTextureName());
        @Nullable String overlayTextureName = variant.getOverlayTextureName();
        int pinkPetalType = shoulderData.pinkPetalType();
        class_1921 baseRenderLayer = class_1921.method_23578((class_2960)baseTextureId);
        this.hamsterShoulderModel.method_60879(matrices, vertexConsumers.getBuffer(baseRenderLayer), light, class_4608.field_21444);
        if (overlayTextureName != null) {
            class_2960 overlayTextureId = this.getTextureId(overlayTextureName);
            class_1921 overlayRenderLayer = class_1921.method_23580((class_2960)overlayTextureId);
            this.hamsterShoulderModel.method_60879(matrices, vertexConsumers.getBuffer(overlayRenderLayer), light, class_4608.field_21444);
        }
        if (pinkPetalType > 0 && pinkPetalType <= 3) {
            class_2960 petalTextureId = class_2960.method_60655((String)"adorablehamsterpets", (String)("textures/entity/hamster/overlay_pink_petal" + pinkPetalType + ".png"));
            class_1921 petalRenderLayer = class_1921.method_23580((class_2960)petalTextureId);
            this.hamsterShoulderModel.method_60879(matrices, vertexConsumers.getBuffer(petalRenderLayer), light, class_4608.field_21444);
        }
        matrices.method_22909();
    }

    private void setCheekVisibility(HamsterShoulderData data) {
        if (this.hamsterShoulderModel.left_cheek_deflated == null || this.hamsterShoulderModel.left_cheek_inflated == null || this.hamsterShoulderModel.right_cheek_deflated == null || this.hamsterShoulderModel.right_cheek_inflated == null) {
            return;
        }
        boolean leftCheekFull = (data.hamsterFlags() & 0x40) != 0;
        boolean rightCheekFull = (data.hamsterFlags() & 0x80) != 0;
        this.hamsterShoulderModel.left_cheek_deflated.field_3665 = !leftCheekFull;
        this.hamsterShoulderModel.left_cheek_inflated.field_3665 = leftCheekFull;
        this.hamsterShoulderModel.right_cheek_deflated.field_3665 = !rightCheekFull;
        this.hamsterShoulderModel.right_cheek_inflated.field_3665 = rightCheekFull;
    }

    private class_2960 getTextureId(String textureName) {
        return class_2960.method_60655((String)"adorablehamsterpets", (String)("textures/entity/hamster/" + textureName + ".png"));
    }
}

