/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterFoundGoldCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterLedToDiamondCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_11;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_167;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_8779;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class HamsterSeekDiamondGoal
extends class_1352 {
    private final HamsterEntity hamster;
    private final class_1937 world;
    private class_2338 targetOrePos;
    private boolean isSeekingGold;
    private SeekingState currentState = SeekingState.IDLE;
    private int pathingTickTimer;
    private int soundTimer;
    @Nullable
    private class_11 path;
    private static final int PATHING_RECHECK_INTERVAL = 20;
    private static final int SNIFF_SOUND_INTERVAL_MOVING = 30;
    private static final int SNIFF_SOUND_INTERVAL_WAITING = 160;

    public HamsterSeekDiamondGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.method_37908();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.world.field_9236 || !Configs.AHP.enableIndependentDiamondSeeking) {
            return false;
        }
        if (!this.hamster.isPrimedToSeekDiamonds) {
            return false;
        }
        if (this.hamster.method_24345() || this.hamster.method_6113() || this.hamster.isKnockedOut() || this.hamster.isCelebratingChase() || this.hamster.isSulking()) {
            return false;
        }
        if (this.hamster.method_5968() != null) {
            return false;
        }
        if (Configs.AHP.enableIndependentDiamondSeekCooldown && this.hamster.foundOreCooldownEndTick > this.world.method_8510()) {
            return false;
        }
        return this.findNewTargetOreAndSetState();
    }

    private boolean findNewTargetOreAndSetState() {
        boolean targetIsGold;
        this.targetOrePos = null;
        this.isSeekingGold = false;
        this.hamster.currentOreTarget = null;
        ArrayList<class_2338> exposedDiamondOres = new ArrayList<class_2338>();
        ArrayList<class_2338> buriedDiamondOres = new ArrayList<class_2338>();
        ArrayList<class_2338> buriedGoldOres = new ArrayList<class_2338>();
        int radius = (Integer)Configs.AHP.diamondSeekRadius.get();
        for (class_2338 pos2 : class_2338.method_25996((class_2338)this.hamster.method_24515(), (int)radius, (int)radius, (int)radius)) {
            class_2680 state = this.world.method_8320(pos2);
            class_2248 block = state.method_26204();
            if (block == class_2246.field_10442 || block == class_2246.field_29029) {
                if (HamsterSeekDiamondGoal.isOreExposed(pos2, this.world)) {
                    exposedDiamondOres.add(pos2.method_10062());
                    continue;
                }
                buriedDiamondOres.add(pos2.method_10062());
                continue;
            }
            if (block != class_2246.field_10571 && block != class_2246.field_29026 || !HamsterSeekDiamondGoal.isOreExposed(pos2, this.world)) continue;
            buriedGoldOres.add(pos2.method_10062());
        }
        boolean bl = targetIsGold = !buriedGoldOres.isEmpty() && this.world.field_9229.method_43057() < ((Float)Configs.AHP.goldMistakeChance.get()).floatValue();
        if (targetIsGold) {
            buriedGoldOres.sort(Comparator.comparingDouble(pos -> pos.method_19770((class_2374)this.hamster.method_19538())));
            this.targetOrePos = (class_2338)buriedGoldOres.get(0);
            this.isSeekingGold = true;
        } else if (!exposedDiamondOres.isEmpty()) {
            exposedDiamondOres.sort(Comparator.comparingDouble(pos -> pos.method_19770((class_2374)this.hamster.method_19538())));
            this.targetOrePos = (class_2338)exposedDiamondOres.get(0);
        } else if (!buriedDiamondOres.isEmpty()) {
            buriedDiamondOres.sort(Comparator.comparingDouble(pos -> pos.method_19770((class_2374)this.hamster.method_19538())));
            this.targetOrePos = (class_2338)buriedDiamondOres.get(0);
        }
        if (this.targetOrePos != null) {
            this.hamster.currentOreTarget = this.targetOrePos;
            this.currentState = SeekingState.SCANNING;
            return true;
        }
        return false;
    }

    public void method_6269() {
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName() + (this.isSeekingGold ? "_Gold" : "_Diamond"));
        this.pathingTickTimer = 0;
        this.soundTimer = 0;
        this.attemptPathToTarget();
    }

    private void attemptPathToTarget() {
        if (this.targetOrePos == null) {
            this.currentState = SeekingState.IDLE;
            return;
        }
        this.path = this.hamster.method_5942().method_6352((double)this.targetOrePos.method_10263() + 0.5, (double)this.targetOrePos.method_10264(), (double)this.targetOrePos.method_10260() + 0.5, 0);
        if (this.path != null) {
            this.hamster.method_5942().method_6334(this.path, 0.5);
            this.currentState = SeekingState.MOVING_TO_ORE;
            this.soundTimer = 15;
        } else {
            this.currentState = SeekingState.WAITING_FOR_PATH;
            this.pathingTickTimer = 20;
            this.soundTimer = 80;
        }
    }

    public boolean method_6266() {
        boolean isTargetGold;
        if (this.currentState == SeekingState.IDLE || this.currentState == SeekingState.CELEBRATING_DIAMOND || this.currentState == SeekingState.SULKING_AT_GOLD) {
            return false;
        }
        if (this.hamster.method_24345() || this.hamster.method_6113() || this.hamster.isKnockedOut() || this.hamster.isSulking()) {
            return false;
        }
        if (this.hamster.method_5968() != null) {
            return false;
        }
        if (this.targetOrePos == null) {
            return false;
        }
        class_2248 targetBlock = this.world.method_8320(this.targetOrePos).method_26204();
        boolean isTargetDiamond = targetBlock == class_2246.field_10442 || targetBlock == class_2246.field_29029;
        boolean bl = isTargetGold = targetBlock == class_2246.field_10571 || targetBlock == class_2246.field_29026;
        if (this.isSeekingGold) {
            return isTargetGold;
        }
        return isTargetDiamond;
    }

    public void method_6268() {
        if (this.targetOrePos == null) {
            this.method_6270();
            return;
        }
        this.hamster.method_5988().method_6230((double)this.targetOrePos.method_10263() + 0.5, (double)this.targetOrePos.method_10264() + 0.5, (double)this.targetOrePos.method_10260() + 0.5, 25.0f, 25.0f);
        if (this.soundTimer > 0) {
            --this.soundTimer;
        }
        switch (this.currentState.ordinal()) {
            case 2: {
                if (this.path != null && !this.world.method_8608()) {
                    int currentNodeIndex = this.path.method_39();
                    int pathLength = this.path.method_38();
                    for (int i = currentNodeIndex; i < pathLength; ++i) {
                        class_9 node = this.path.method_40(i);
                        class_243 directionVector = class_243.field_1353;
                        if (i + 1 < pathLength) {
                            class_9 nextNode = this.path.method_40(i + 1);
                            directionVector = new class_243((double)(nextNode.field_40 - node.field_40), 0.0, (double)(nextNode.field_38 - node.field_38)).method_1029();
                        }
                        for (int p = 0; p < 3; ++p) {
                            double distanceAlongPath = this.world.field_9229.method_43058();
                            class_243 pathOffset = directionVector.method_1021(distanceAlongPath);
                            double offsetY = (this.world.field_9229.method_43058() - 0.5) * 0.1;
                            ((class_3218)this.world).method_14199((class_2394)class_2398.field_11219, (double)node.field_40 + 0.5 + pathOffset.field_1352, (double)node.field_39 + 0.5 - 0.38 + offsetY, (double)node.field_38 + 0.5 + pathOffset.field_1350, 1, 0.2, 0.0, 0.2, 3.0);
                        }
                    }
                }
                if (this.hamster.method_5942().method_6357() || this.hamster.method_24515().method_19771((class_2382)this.targetOrePos, 1.5)) {
                    if (this.hamster.method_24515().method_19771((class_2382)this.targetOrePos, 1.5)) {
                        this.onOreReached();
                        break;
                    }
                    this.path = null;
                    this.currentState = SeekingState.WAITING_FOR_PATH;
                    this.pathingTickTimer = 20;
                    this.soundTimer = 80;
                    break;
                }
                if (this.soundTimer > 0) break;
                this.playSniffSound();
                this.soundTimer = 30;
                break;
            }
            case 3: {
                if (this.pathingTickTimer > 0) {
                    --this.pathingTickTimer;
                } else {
                    this.attemptPathToTarget();
                }
                if (this.soundTimer > 0) break;
                this.playSniffSound();
                this.soundTimer = 160;
            }
        }
    }

    private void onOreReached() {
        this.hamster.method_5942().method_6340();
        this.hamster.isPrimedToSeekDiamonds = false;
        if (Configs.AHP.enableIndependentDiamondSeekCooldown) {
            this.hamster.foundOreCooldownEndTick = this.world.method_8510() + (long)((Integer)Configs.AHP.independentOreSeekCooldownTicks.get()).intValue();
        }
        if (this.isSeekingGold) {
            this.currentState = SeekingState.SULKING_AT_GOLD;
            class_1309 class_13092 = this.hamster.method_35057();
            if (class_13092 instanceof class_3222) {
                class_3222 owner = (class_3222)class_13092;
                if (this.hamster.method_5858((class_1297)owner) < 36.0) {
                    this.hamster.method_5988().method_6226((class_1297)owner, 25.0f, 25.0f);
                }
                this.sendMessageToOwner(owner);
            }
            class_243 awayFromOre = this.hamster.method_19538().method_1020(class_243.method_24953((class_2382)this.targetOrePos)).method_1029();
            this.hamster.method_18800(awayFromOre.field_1352 * 0.1, 0.5, awayFromOre.field_1350 * 0.1);
            this.hamster.field_6007 = true;
            class_3414 bounceSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BOUNCE_SOUNDS, this.hamster.method_59922());
            if (bounceSound != null) {
                this.world.method_8396(null, this.hamster.method_24515(), bounceSound, class_3419.field_15254, 0.6f, this.hamster.method_6017());
            }
            this.hamster.setSulking(true);
            this.hamster.triggerAnimOnServer("mainController", "anim_hamster_sulk");
        } else {
            this.currentState = SeekingState.CELEBRATING_DIAMOND;
            this.hamster.setCelebratingDiamond(true);
            AdorableHamsterPets.LOGGER.debug("Hamster {} reached CELEBRATING_DIAMOND state for ore at {}", (Object)this.hamster.method_5628(), (Object)this.targetOrePos);
            class_1309 class_13093 = this.hamster.method_35057();
            if (class_13093 instanceof class_3222) {
                class_3222 serverPlayerOwner = (class_3222)class_13093;
                ((HamsterLedToDiamondCriterion)((Object)ModCriteria.HAMSTER_LED_TO_DIAMOND.get())).trigger(serverPlayerOwner, this.hamster, this.targetOrePos);
            }
        }
    }

    private void playSniffSound() {
        class_3414 sniffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, this.hamster.method_59922());
        if (sniffSound != null) {
            this.world.method_8396(null, this.hamster.method_24515(), sniffSound, class_3419.field_15254, 3.0f, this.hamster.method_6017());
        }
    }

    public void method_6270() {
        this.path = null;
        this.hamster.method_5942().method_6340();
        boolean targetOreStillExists = false;
        if (this.targetOrePos != null) {
            boolean isTargetGold;
            class_2248 targetBlock = this.world.method_8320(this.targetOrePos).method_26204();
            boolean isTargetDiamond = targetBlock == class_2246.field_10442 || targetBlock == class_2246.field_29029;
            boolean bl = isTargetGold = targetBlock == class_2246.field_10571 || targetBlock == class_2246.field_29026;
            if (this.isSeekingGold && isTargetGold) {
                targetOreStillExists = true;
            }
            if (!this.isSeekingGold && isTargetDiamond) {
                targetOreStillExists = true;
            }
        }
        if (this.currentState != SeekingState.CELEBRATING_DIAMOND && this.currentState != SeekingState.SULKING_AT_GOLD && !targetOreStillExists) {
            this.hamster.isPrimedToSeekDiamonds = false;
        }
        if (this.hamster.isCelebratingDiamond() && (this.currentState != SeekingState.CELEBRATING_DIAMOND || !targetOreStillExists)) {
            this.hamster.setCelebratingDiamond(false);
        }
        if (this.hamster.getActiveCustomGoalDebugName().startsWith(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
        this.currentState = SeekingState.IDLE;
        this.targetOrePos = null;
    }

    private void sendMessageToOwner(class_3222 owner) {
        int messageIndex;
        class_2985 tracker = owner.method_14236();
        class_2960 advId = class_2960.method_60655((String)"adorablehamsterpets", (String)"technical/hamster_found_gold_first_time");
        class_8779 advancement = owner.field_13995.method_3851().method_12896(advId);
        if (advancement == null) {
            AdorableHamsterPets.LOGGER.debug("[GoldMessage] CRITICAL: Could not find advancement '{}'. Message will not be sent. Check file path and JSON validity.", (Object)advId);
            return;
        }
        class_167 progress = tracker.method_12882(advancement);
        if (!progress.method_740()) {
            messageIndex = 0;
            for (String criterion : advancement.comp_1920().comp_1915().keySet()) {
                tracker.method_12878(advancement, criterion);
            }
        } else {
            PlayerEntityAccessor accessor = (PlayerEntityAccessor)owner;
            int lastIndex = accessor.ahp_getLastGoldMessageIndex();
            List possibleIndices = IntStream.range(0, 7).boxed().collect(Collectors.toList());
            if (lastIndex >= 0 && lastIndex < 7) {
                possibleIndices.remove((Object)lastIndex);
            }
            messageIndex = (Integer)possibleIndices.get(this.world.field_9229.method_43048(possibleIndices.size()));
        }
        ((PlayerEntityAccessor)owner).ahp_setLastGoldMessageIndex(messageIndex);
        String messageKey = "message.adorablehamsterpets.found_gold_mistake." + (messageIndex + 1);
        owner.method_7353((class_2561)class_2561.method_43471((String)messageKey).method_27692(class_124.field_1065), true);
        ((HamsterFoundGoldCriterion)((Object)ModCriteria.HAMSTER_FOUND_GOLD.get())).trigger(owner);
    }

    public static boolean isOreExposed(class_2338 orePos, class_1937 world) {
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjacentPos = orePos.method_10093(direction);
            if (!world.method_8320(adjacentPos).method_26194((class_1922)world, adjacentPos, class_3726.method_16194()).method_1110()) continue;
            return true;
        }
        return false;
    }

    private static enum SeekingState {
        IDLE,
        SCANNING,
        MOVING_TO_ORE,
        WAITING_FOR_PATH,
        CELEBRATING_DIAMOND,
        SULKING_AT_GOLD;

    }
}

