/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.HashSet;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.client.sound.HamsterFlightSoundInstance;
import net.dawson.adorablehamsterpets.client.sound.HamsterThrowSoundInstance;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountPressType;
import net.dawson.adorablehamsterpets.config.DismountTriggerType;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.client.HamsterRenderer;
import net.dawson.adorablehamsterpets.entity.client.ModModelLayers;
import net.dawson.adorablehamsterpets.entity.client.model.HamsterShoulderModel;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.networking.payload.DismountHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.StartHamsterFlightSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.StartHamsterThrowSoundPayload;
import net.dawson.adorablehamsterpets.networking.payload.ThrowHamsterPayload;
import net.dawson.adorablehamsterpets.networking.payload.UpdateHamsterRenderStatePayload;
import net.dawson.adorablehamsterpets.screen.HamsterInventoryScreen;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3872;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_5601;
import net.minecraft.class_8710;
import net.minecraft.class_9334;

public class AdorableHamsterPetsClient {
    private static final Set<Integer> renderedHamsterIdsThisTick = new HashSet<Integer>();
    private static final Set<Integer> renderedHamsterIdsLastTick = new HashSet<Integer>();
    private static long lastSneakPressTime = 0L;
    private static boolean isWaitingForSecondSneakPress = false;
    private static boolean hadShoulderHamsterLastTick = false;
    private static int dismountDebounceTicks = 0;
    private static final int DISMOUNT_DEBOUNCE_DEFAULT = 5;

    public static void init() {
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)ModBlocks.GREEN_BEANS_CROP.get(), (class_2248)ModBlocks.CUCUMBER_CROP.get(), (class_2248)ModBlocks.SUNFLOWER_BLOCK.get(), (class_2248)ModBlocks.WILD_CUCUMBER_BUSH.get(), (class_2248)ModBlocks.WILD_GREEN_BEAN_BUSH.get()});
        ModPackets.registerS2CPackets();
        ClientTickEvent.CLIENT_POST.register(AdorableHamsterPetsClient::onEndClientTick);
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> -1, (class_1935[])new class_1935[]{(class_1935)ModItems.HAMSTER_SPAWN_EGG.get()});
        InteractionEvent.RIGHT_CLICK_ITEM.register((player, hand) -> {
            class_3872.class_3931 contents;
            class_1799 stack = player.method_5998(hand);
            if (player.method_37908().field_9236 && stack.method_31574((class_1792)ModItems.HAMSTER_GUIDE_BOOK.get()) && stack.method_57826(class_9334.field_49606) && (contents = class_3872.class_3931.method_17562((class_1799)stack)) != null) {
                class_310.method_1551().method_1507((class_437)new class_3872(contents));
                return CompoundEventResult.interrupt((Boolean)true, (Object)stack);
            }
            return CompoundEventResult.pass();
        });
    }

    public static void initScreenHandlers() {
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get()), HamsterInventoryScreen::new);
    }

    public static void initEntityRenderers() {
        EntityRendererRegistry.register(ModEntities.HAMSTER, HamsterRenderer::new);
    }

    public static void initModelLayers() {
        EntityModelLayerRegistry.register((class_5601)ModModelLayers.HAMSTER_SHOULDER_LAYER, HamsterShoulderModel::getTexturedModelData);
    }

    public static void onHamsterRendered(int entityId) {
        renderedHamsterIdsThisTick.add(entityId);
    }

    private static void onEndClientTick(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            renderedHamsterIdsThisTick.clear();
            renderedHamsterIdsLastTick.clear();
            return;
        }
        if (ModKeyBindings.THROW_HAMSTER_KEY.method_1436()) {
            AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
            if (!currentConfig.enableHamsterThrowing) {
                client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.throwing_disabled"), true);
            } else {
                boolean hasShoulderHamsterClient;
                boolean lookingAtReachableBlock = client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1332;
                boolean bl = hasShoulderHamsterClient = !((PlayerEntityAccessor)client.field_1724).getHamsterShoulderEntity().method_33133();
                if (!lookingAtReachableBlock && hasShoulderHamsterClient) {
                    NetworkManager.sendToServer((class_8710)new ThrowHamsterPayload());
                }
            }
        }
        HashSet<Integer> stoppedRendering = new HashSet<Integer>(renderedHamsterIdsLastTick);
        stoppedRendering.removeAll(renderedHamsterIdsThisTick);
        for (Integer entityId : stoppedRendering) {
            NetworkManager.sendToServer((class_8710)new UpdateHamsterRenderStatePayload(entityId, false));
        }
        renderedHamsterIdsLastTick.clear();
        renderedHamsterIdsLastTick.addAll(renderedHamsterIdsThisTick);
        renderedHamsterIdsThisTick.clear();
        AdorableHamsterPetsClient.handleDismountKeyPress(client);
    }

    public static void handleStartFlightSound(StartHamsterFlightSoundPayload payload) {
        HamsterEntity hamster;
        class_3414 flightSound;
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_1297 entity = client.field_1687.method_8469(payload.hamsterEntityId());
        if (entity instanceof HamsterEntity && (flightSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, (hamster = (HamsterEntity)entity).method_59922())) != null) {
            client.method_1483().method_4873((class_1113)new HamsterFlightSoundInstance(flightSound, class_3419.field_15254, hamster));
        }
    }

    public static void handleStartThrowSound(StartHamsterThrowSoundPayload payload) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        class_1297 entity = client.field_1687.method_8469(payload.hamsterEntityId());
        if (entity instanceof HamsterEntity) {
            HamsterEntity hamster = (HamsterEntity)entity;
            client.method_1483().method_4873((class_1113)new HamsterThrowSoundInstance((class_3414)ModSounds.HAMSTER_THROW.get(), class_3419.field_15248, hamster));
        }
    }

    private static void handleDismountKeyPress(class_310 client) {
        long delayMillis;
        long currentTime;
        boolean hasShoulderHamster;
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        boolean bl = hasShoulderHamster = !((PlayerEntityAccessor)client.field_1724).getHamsterShoulderEntity().method_33133();
        if (hasShoulderHamster && !hadShoulderHamsterLastTick) {
            class_304 vanillaSneak = client.field_1690.field_1832;
            class_304 customDismount = ModKeyBindings.DISMOUNT_HAMSTER_KEY;
            if (vanillaSneak != null) {
                vanillaSneak.method_23481(false);
                while (vanillaSneak.method_1436()) {
                }
            }
            if (customDismount != null) {
                customDismount.method_23481(false);
                while (customDismount.method_1436()) {
                }
            }
            dismountDebounceTicks = 5;
            isWaitingForSecondSneakPress = false;
            AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Mount transition detected -> draining input queues and starting debounce ({} ticks).", (Object)5);
        }
        hadShoulderHamsterLastTick = hasShoulderHamster;
        if (!hasShoulderHamster) {
            if (isWaitingForSecondSneakPress) {
                isWaitingForSecondSneakPress = false;
            }
            return;
        }
        if (dismountDebounceTicks > 0) {
            --dismountDebounceTicks;
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        class_304 keyToListenFor = Configs.AHP.dismountTriggerType == DismountTriggerType.CUSTOM_KEYBIND ? ModKeyBindings.DISMOUNT_HAMSTER_KEY : client.field_1690.field_1832;
        boolean wasKeyPressed = keyToListenFor != null && keyToListenFor.method_1436();
        AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: Listening for '{}'. wasPressed() = {}", (Object)(keyToListenFor != null ? keyToListenFor.method_1431() : "null-binding"), (Object)wasKeyPressed);
        if (wasKeyPressed) {
            AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: SINGLE_PRESS detected. Press type config: {}", config.dismountPressType.get());
            if (config.dismountPressType.get() == DismountPressType.SINGLE_PRESS) {
                NetworkManager.sendToServer((class_8710)new DismountHamsterPayload());
            } else {
                currentTime = System.currentTimeMillis();
                delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L;
                if (isWaitingForSecondSneakPress && currentTime - lastSneakPressTime <= delayMillis) {
                    AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP second press detected. Sending dismount payload.");
                    NetworkManager.sendToServer((class_8710)new DismountHamsterPayload());
                    isWaitingForSecondSneakPress = false;
                } else {
                    AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP first press detected. Starting timer.");
                    isWaitingForSecondSneakPress = true;
                    lastSneakPressTime = currentTime;
                }
            }
        }
        if (isWaitingForSecondSneakPress && (currentTime = System.currentTimeMillis()) - lastSneakPressTime > (delayMillis = (long)((Integer)config.doubleTapDelayTicks.get()).intValue() * 50L)) {
            AdorableHamsterPets.LOGGER.debug("[AHP DEBUG CLIENT] Tick Handler: DOUBLE_TAP timed out.");
            isWaitingForSecondSneakPress = false;
        }
    }
}

